
;;;
;;; SOKOBAN TRANSLATED MAP:
;;;
;;; x: 9, y: 10
;;;
;;;     
;;; 
;;;  ####
;;; ##  ####
;;; #..$  .#
;;; # #$ $ #
;;; #@  #  #
;;; #####  #
;;;     ####
;;; 
;;; 


(define (problem translated-sokoban)
   (:domain typed-sokoban)
   (:objects
      up down left right - direction
      ball0 ball1 ball2 - ball
      f2-3f f3-3f 
      f1-4f f2-4f f3-4f f4-4f f5-4f f6-4f 
      f1-5f f3-5f f4-5f f5-5f f6-5f 
      f1-6f f2-6f f3-6f f5-6f f6-6f 
      f5-7f f6-7f - navigable
   )

   (:init

      (adjacent f2-3f f3-3f right)
      (adjacent f2-3f f2-4f down)
      (adjacent f3-3f f2-3f left)
      (adjacent f3-3f f3-4f down)
      (adjacent f1-4f f2-4f right)
      (adjacent f1-4f f1-5f down)
      (adjacent f2-4f f3-4f right)
      (adjacent f2-4f f1-4f left)
      (adjacent f2-4f f2-3f up)
      (adjacent f3-4f f4-4f right)
      (adjacent f3-4f f2-4f left)
      (adjacent f3-4f f3-5f down)
      (adjacent f3-4f f3-3f up)
      (adjacent f4-4f f5-4f right)
      (adjacent f4-4f f3-4f left)
      (adjacent f4-4f f4-5f down)
      (adjacent f5-4f f6-4f right)
      (adjacent f5-4f f4-4f left)
      (adjacent f5-4f f5-5f down)
      (adjacent f6-4f f5-4f left)
      (adjacent f6-4f f6-5f down)
      (adjacent f1-5f f1-6f down)
      (adjacent f1-5f f1-4f up)
      (adjacent f3-5f f4-5f right)
      (adjacent f3-5f f3-6f down)
      (adjacent f3-5f f3-4f up)
      (adjacent f4-5f f5-5f right)
      (adjacent f4-5f f3-5f left)
      (adjacent f4-5f f4-4f up)
      (adjacent f5-5f f6-5f right)
      (adjacent f5-5f f4-5f left)
      (adjacent f5-5f f5-6f down)
      (adjacent f5-5f f5-4f up)
      (adjacent f6-5f f5-5f left)
      (adjacent f6-5f f6-6f down)
      (adjacent f6-5f f6-4f up)
      (adjacent f1-6f f2-6f right)
      (adjacent f1-6f f1-5f up)
      (adjacent f2-6f f3-6f right)
      (adjacent f2-6f f1-6f left)
      (adjacent f3-6f f2-6f left)
      (adjacent f3-6f f3-5f up)
      (adjacent f5-6f f6-6f right)
      (adjacent f5-6f f5-7f down)
      (adjacent f5-6f f5-5f up)
      (adjacent f6-6f f5-6f left)
      (adjacent f6-6f f6-7f down)
      (adjacent f6-6f f6-5f up)
      (adjacent f5-7f f6-7f right)
      (adjacent f5-7f f5-6f up)
      (adjacent f6-7f f5-7f left)
      (adjacent f6-7f f6-6f up)

      (empty f2-3f)
      (empty f3-3f)
      (empty f1-4f)
      (empty f2-4f)
      (empty f4-4f)
      (empty f5-4f)
      (empty f6-4f)
      (empty f1-5f)
      (empty f4-5f)
      (empty f6-5f)
      (empty f2-6f)
      (empty f3-6f)
      (empty f5-6f)
      (empty f6-6f)
      (empty f5-7f)
      (empty f6-7f)

      (at ball0 f3-4f)
      (at ball1 f3-5f)
      (at ball2 f5-5f)

      (at-robot f1-6f)
   )

   (:goal
      (and

      (at ball0 f1-4f)
      (at ball1 f2-4f)
      (at ball2 f6-4f)
      )
   )
)

