
;;;
;;; SOKOBAN TRANSLATED MAP:
;;;
;;; x: 7, y: 5
;;;
;;; ####
;;; #@ ###
;;; #  $ #
;;; #.   #
;;; ######
;;; 


(define (problem translated-sokoban)
   (:domain typed-sokoban)
   (:objects
      up down left right - direction
      ball0 - ball
      f1-1f f2-1f 
      f1-2f f2-2f f3-2f f4-2f 
      f1-3f f2-3f f3-3f f4-3f - navigable
   )

   (:init

      (adjacent f1-1f f2-1f right)
      (adjacent f1-1f f1-2f down)
      (adjacent f2-1f f1-1f left)
      (adjacent f2-1f f2-2f down)
      (adjacent f1-2f f2-2f right)
      (adjacent f1-2f f1-3f down)
      (adjacent f1-2f f1-1f up)
      (adjacent f2-2f f3-2f right)
      (adjacent f2-2f f1-2f left)
      (adjacent f2-2f f2-3f down)
      (adjacent f2-2f f2-1f up)
      (adjacent f3-2f f4-2f right)
      (adjacent f3-2f f2-2f left)
      (adjacent f3-2f f3-3f down)
      (adjacent f4-2f f3-2f left)
      (adjacent f4-2f f4-3f down)
      (adjacent f1-3f f2-3f right)
      (adjacent f1-3f f1-2f up)
      (adjacent f2-3f f3-3f right)
      (adjacent f2-3f f1-3f left)
      (adjacent f2-3f f2-2f up)
      (adjacent f3-3f f4-3f right)
      (adjacent f3-3f f2-3f left)
      (adjacent f3-3f f3-2f up)
      (adjacent f4-3f f3-3f left)
      (adjacent f4-3f f4-2f up)

      (empty f2-1f)
      (empty f1-2f)
      (empty f2-2f)
      (empty f4-2f)
      (empty f1-3f)
      (empty f2-3f)
      (empty f3-3f)
      (empty f4-3f)

      (at ball0 f3-2f)

      (at-robot f1-1f)
   )

   (:goal
      (and

      (at ball0 f1-3f)
      )
   )
)

