(define (domain typed-sokoban)
(:requirements :strips :typing)
(:types direction
        ball
        navigable)
(:predicates (at-robot ?l - navigable)
             (at ?o - ball ?l - navigable)
             (adjacent ?l1 ?l2 - navigable ?d - direction) 
             (empty ?l - navigable))
(:action push
  :parameters  (?rloc - navigable ?bloc - navigable ?floc - navigable ?dir - direction ?b - ball)
  :precondition (and (at-robot ?rloc)
                     (at ?b ?bloc) (adjacent ?rloc ?bloc ?dir)
                     (adjacent ?bloc ?floc ?dir) (empty ?floc))
  :effect (and (at-robot ?bloc) (at ?b ?floc) (empty ?rloc)
               (not (at-robot ?rloc)) (not (at ?b ?bloc)) (not (empty ?floc))))
(:action move
  :parameters (?from - navigable ?to - navigable ?dir - direction)
  :precondition (and (at-robot ?from) (adjacent ?from ?to ?dir) (empty ?to))
  :effect (and (empty ?from) (at-robot ?to) (not (empty ?to))
               (not (at-robot ?from)))))
