/****************************************************** 
 * File  : Npuzzle.cc   
 * Desc. : Generator program for NADL n-puzzle domains (n is the grid size,
 *         thus the regular 7-puzzle has n=3)
 * Author: Rune M. Jensen CS, CMU
 * Date  : 1/12/01
 ******************************************************/

#include <math.h>
#include <iostream.h>
#include <fstream.h>
#include <stdlib.h>


int main(int argc, char **argv) {
  
  int i,j,k;
  int n,tilenum;

  // check input
  if (argc != 3)
    {
      cout << "Usage: Npuzzle <n> <domain>.nadl\n";
      exit(1);
    }

  ofstream  out(argv[2],ios::out);
  n = atoi(argv[1]);
  tilenum = n*n - 1;
  
  // write head
  out << "\% File:   " << argv[2] << "\n";
  out << "\% Desc:   Npuzzle with grid size " << n << "\n";
  out << "\% Date:   01\n";
  out << "\% Auth:   Rune M. Jensen CS, CMU\n";

  // write variables
  out << "\nVARIABLES\n";
  out << "  nat(" << int(ceil(log(n)/log(2))) << ") "; 
  for (i=0; i<tilenum; i++) {
    if (i != 0) out << ", ";
    out << "x" << i << ", y" << i;
  }

  // write actions
  out << "\n\n\nSYSTEM\n";
  out << "\n  agt: Action";
  
  for (i=0; i < tilenum; i++) {
    
    out << "\n\n";
    

    out << "   Left" << i << "\n";
    out << "     con: x" << i << endl;
    out << "     pre: x" << i << " > 0\n";
    for (j = 0; j < tilenum; j++)
      if (i != j)
	out << "           /\\ ( x" << j << " <> x" << i << " - 1 \\/ y" << j << " <> y" << i << " )\n";
    out << "     eff: x" << i << "' = x" << i << " - 1 \n\n\n";
    


    out << "   Right" << i << "\n";
    out << "     con: x" << i << endl;
    out << "     pre: x" << i << " < " << n - 1 << endl;
    for (j = 0; j < tilenum; j++)
      if (i != j)
	out << "           /\\ ( x" << j << " <> x" << i << " + 1 \\/ y" << j << " <> y" << i << " )\n";
    out << "     eff: x" << i << "' = x" << i << " + 1 \n\n\n";


    out << "   Up" << i << "\n";
    out << "     con: y" << i << endl;
    out << "     pre: y" << i << " < " << n - 1 << endl;
    for (j = 0; j < tilenum; j++)
      if (i != j)
	out << "           /\\ ( x" << j << " <> x" << i << " \\/ y" << j << " <> y" << i << " + 1 )\n";
    out << "     eff: y" << i << "' = y" << i << " + 1 \n\n\n";



    out << "    Down" << i << "\n";
    out << "     con: y" << i << endl;
    out << "     pre: y" << i << " > 0\n";
    for (j = 0; j < tilenum; j++)
      if (i != j)
	out << "           /\\ ( x" << j << " <> x" << i << " \\/ y" << j << " <> y" << i << " - 1 )\n";
    out << "     eff: y" << i << "' = y" << i << " - 1 \n\n\n";


  }

  out << "ENVIRONMENT\n\n";

  out << "INITIALLY\n";
  k = tilenum-1;
  for (i=n-1; i >= 0; i--)
    for (j=0; j < n; j++)
      if (i != 0 || j != n-1) {
	if (i != n-1 || j != 0) out << "   /\\ ";
	out << "   x" << k << " = "  << j << " /\\ y" << k << " = " << i << endl;
	k--;
      }

  
  out << "\nGOAL\n";
  k = 0;
  for (i=n-1; i >= 0; i--)
    for (j=0; j < n; j++)
      if (i != 0 || j != n-1) {
	if (i != n-1 || j != 0) out << "   /\\ ";
	out << "   x" << k << " = "  << j << " /\\ y" << k << " = " << i << endl;
	k++;
      }


}

