/****************************************************** 
 * File  : pddlR.c   
 * Desc. : manipulation files for domain and problem
 *         data structures
 * Author: Rune M. Jensen
 * Date  : 10/16/00
 ******************************************************/
#include <stdio.h>
#include "pddlR.h"
#include "common.h"

/*** constructors ***/

char *copystr(char *str) {
  char *s;
  s = (char*) malloc(MAXNAMELENGTH);
  strcpy(s,str);
}

  
arglst *consarg(arglst *hd, arglst *tl) {
  hd->next = tl;
  return hd;
}


arglst *newarg(char *name) {
  arglst *res;
  
  res = (arglst*) malloc(sizeof(arglst));
  res->name = name;
  return res;
}


predlst *conspred(predlst *hd,predlst *tl) {
  hd->next = tl;
  return hd;
}


predlst *newpred(char *name, arglst *args) {
  predlst *res;
  
  res = (predlst*) malloc(sizeof(predlst));
  res->name = name;
  res->args = args;
  return res;
}


litlst *conslit(litlst *hd,litlst *tl) {
  hd->next = tl;
  return hd;
}


litlst *newlit(char *name,int sign,arglst *args) {
  litlst *res;
  
  res = (litlst*) malloc(sizeof(litlst));
  res->name = name;
  res->sign = sign;
  res->args = args;
  return res;
}


actionlst *consaction(actionlst *hd,actionlst *tl) {
  hd->next = tl;
  return hd;
}


actionlst *newaction(char *name, arglst *params,litlst *pre,predlst *add,predlst *del) {
  actionlst *res;
  
  res = (actionlst*) malloc(sizeof(actionlst));
  res->name = name;
  res->params = params;
  res->pre = pre;
  res->add = add;
  res->del = del;
  return res;
}


/*** destructors ***/

predlst *dellist(litlst *effect) {
  predlst *res;
  predlst *pred;
  
  res = NULL;
  
  while (effect) {
    {
      if (effect->sign == 0)
	{
	  pred = newpred(effect->name,effect->args);
	  res = conspred(pred,res);
	}
      effect = effect->next;
    }
  }
  return res;
}

predlst *addlist(litlst *effect) {
  predlst *res;
  predlst *pred;
  
  res = NULL;
  
  while (effect) {
    {
      if (effect->sign == 1)
	{
	  pred = newpred(effect->name,effect->args);
	  res = conspred(pred,res);
	}
      effect = effect->next;
    }
  }
  return res;
}




/*** print functions ***/

void printarglst(arglst *args) {
  if (args) {
    printf("%s",args->name);
    if (args->next) printf(",");
    printarglst(args->next);
  }
}
   
void printpredlst(predlst *preds) {
  if (preds) {
    printf("%s(",preds->name);
    printarglst(preds->args);
    printf(")");
    if (preds->next) printf(",");
    printpredlst(preds->next);
  }
}
 
void printlitlst(litlst *lits)  {
  if (lits) {
    if (lits->sign == 0) printf("~");
    printf("%s(",lits->name);
    printarglst(lits->args);
    printf(")");
    if (lits->next) printf(",");
    printlitlst(lits->next);
  }
}

void printactionlst(actionlst *acts) { 
  if (acts) {
    printf("\n\n%s", acts->name);
    printf("\n  par: ");
    printarglst(acts->params);
    printf("\n  pre: ");
    printlitlst(acts->pre);
    printf("\n  add: ");
    printpredlst(acts->add);
    printf("\n  del: ");
    printpredlst(acts->del); 
    
    printactionlst(acts->next);
  }
}    
      
void printdomain(domain *dom) {
  printf("\n\n%s",dom->name);
  printf("\npredicates: ");
  printpredlst(dom->predicates);
  printactionlst(dom->actions);
  printf("\n\n");
}
  
void printproblem(problem *prob) {
  printf("\n\nProblem: %s",prob->name);
  printf("\nObjects: ");
  printarglst(prob->objects);
  printf("\n\n");  
  printf("\ninit: ");
  printpredlst(prob->init);
  printf("\n\n");
  printf("\ngoal: ");  
  printpredlst(prob->goal);
  printf("\n\n");
}
  

