/****************************************************** 
 * File  : main.cc   
 * Desc. : PDDL NADL translator for AIPS-2000 
 *         elevator domain (Track1, untyped
 *         base set (does not handle additional set))
 * Author: Rune M. Jensen
 * Date  : 11/10/00
 ******************************************************/
#include <stream.h>
#include <fstream.h>
#include <string.h>
#include <stdio.h> 
#include <stdlib.h>
#include <math.h>
#include <map>
#include <set>
#include <string>
#include "set.h"
#include "common.h"
#include "pddlRcpp.h"
#include "main.h"

// globals used by LEX/YACC parsing
domain *dom;
problem *prob;


void  printusage() {
  printf("USAGE:\n");
  printf("       -p <problem name>               (default prob)\n");  
  printf("       -h print usage\n");
  printf("      ");
  printf("\n");
}



int numberof(char *str) {
  char  buf[512];
  char *p;
  strcpy(buf,str);
  p = &buf[1];
  
  return atoi(p);
}


char *nameof(char *str) {
  char *buf;
  char *p;
  buf = new char[512];
  strcpy(buf,str);
  buf[1] = '\0';
  
  return buf;
}
  



int main(int argc,char **argv)  {
  extern FILE *yyin;
  extern int yylineno;


  // input parameters
  char pddlname[MAXNAMELENGTH];
  char nadlname[MAXNAMELENGTH];
  char name[MAXNAMELENGTH]  = "prob";

  int ind,i,j;


  if (argc < 2) {
    printusage();
    exit (-1);
  }


  /*** Scan command line ***/
  for (ind = 1; ind < argc; ind++) {

    /*** Parse switches ***/
    if (argv[ind][0] == '-') {
      switch (argv[ind][1]) {  
      case 'h':   printusage(); exit(0);
	break;
      case 'p': strcpy(name,argv[++ind]);
	break;
      default : printf("Unknown switch '%c'\n", argv[ind][1]);
	break;
      }
    }
  }


  sprintf(pddlname,"%s.pddl",name);
  sprintf(nadlname,"%s.nadl",name);
  

  /*** allocate domain and problem structures **/
  dom =  new domain;
  prob = new problem;

  /*** parse PDDL problem ***/
  if ( (yyin = fopen(pddlname,"r")) == NULL)
    {
      cout << "Cannot open \"" << pddlname << "\"\n"; 
      exit(-1);
    }

  cout << "parsing : " << pddlname << "\n";
  yylineno = 0;
  if (yyparse()) exit(-1); 

  // debug
  // cout << "PDDL PROBLEM :\n";
  // printproblem(prob);
   
  int floornum = 0;
  int personnum = 0;
  
  // go through init and instantiate maps;
  for (predlst* pl = prob->init; pl != NULL; pl = pl->next)
    if (!strcmp(pl->name,"above")) {
      int cand;
      cand = numberof(pl->args->next->name) + 1;
      if (cand > floornum) floornum = cand;
    }
    else if (!strcmp(pl->name,"origin")) {
      int cand; 
      cand = numberof(pl->args->name) + 1;
      if (cand > personnum) personnum = cand;
    }
  
  
  // debug
  //cout << personnum << " " << floornum  << "\n";
  //exit(1);
  
  
  ofstream out(nadlname,ios::out);
  out << "\% File : " << nadlname << endl;
  out << "\% Desc : Translation of AIPS-00 Track 1, typed,  miconic problem\n";
  out << "\%        " << pddlname << endl;
  out << "\% Date : 11/00\n";
  out << "\% Auth : Rune M. Jensen CS, CMU\n\n\n";
  
  out << "VARIABLES\n";
  
  out << "\n   nat(" << int(ceil( log(floornum+1)/log(2))) << ") ";
  out << "poslift";  
  for (i = 0; i < personnum; i++) 
    out << ", posperson" << i+1;
  
  
  
  // person positions are ordered 
  //
  // ...
  // 2 floor 2
  // 1 floor 1
  // 0 in lift 
  
  
  out << "\n\nSYSTEM\n\n";
  out << "  agt: sys\n\n";
  
  
  for (i=0; i<personnum; i++)
    {
      out << "  boardPerson" << i + 1 << endl;
      out << "    con: posperson" << i + 1 << endl;
      out << "    pre: posperson" << i + 1 << " = poslift\n";
      out << "    eff: posperson" << i + 1 << "' =  0 \n\n";
    }
  
  
  for (i=0; i<personnum; i++)
    {
      out << "  departPerson" << i + 1 << endl;
      out << "    con: posperson" << i + 1 << endl;
      out << "    pre: posperson" << i + 1 << " = 0\n";
      out << "    eff: posperson" << i + 1 << "' = poslift\n\n";
    }
  
  
  out << "  goUp\n";
  out << "    con: poslift\n";
  out << "    pre: true\n";
  out << "    eff: poslift' = poslift + 1\n\n";
  
  out << "  goDown\n";
  out << "    con: poslift\n";
  out << "    pre: true\n";
  out << "    eff: poslift' = poslift - 1\n\n";
  
  
  
  
  
  out << "ENVIRONMENT\n \nINITIALLY\n";
  
  int flag;
  flag  = 0;
  
  for (predlst* pl = prob->init; pl != NULL; pl = pl->next)
    {
      if (!strcmp(pl->name,"origin")) {
	if (flag) out << " /\\ "; 
	flag = 1;
	out << "posperson" << numberof(pl->args->name) + 1 << " = " << numberof(pl->args->next->name) + 1;
      }
	
      if (!strcmp(pl->name,"lift-at")) {
	if (flag) out << " /\\ "; 
	flag = 1;
	out << "poslift = " << numberof(pl->args->name) + 1;
      }
    }

  out << "\n\nGOAL\n";

 flag  = 0;
  
 for (predlst* pl = prob->init; pl != NULL; pl = pl->next)
   {
     if (!strcmp(pl->name,"destin")) {
       if (flag) out << " /\\ "; 
       flag = 1;
       out << "posperson" << numberof(pl->args->name) + 1<< " = " << numberof(pl->args->next->name) + 1;
     }
   }
 
 
  return 0;
}



    
