/*========================================================================
                              
                                ** UMOP **
		** Universal Multi-Agent OBDD-based Planner **

            Copyright (C) 1999 by Rune M. Jensen and Manuela M. Veloso
            Computer Science Department, Carnegie Mellon University.
            
    Permission is hereby granted to distribute the UMOP software for 
    research purposes, provided this notice is included with any such 
    distribution. 

      *** WE ARE NOT RESPONSIBLE FOR ANY KIND OF DAMAGE TO YOUR  ***
      *** FILES, DATA, HARDWARE, LOSS OF MONEY, SYSTEM CRASHES   *** 
      *** OR ANY OTHER THING YOU MIGHT COME UP WITH.             ***
      *** - USE THIS PROGRAM OF YOUR OWN FREE WILL !!!           ***

========================================================================*/
/****************************************************** 
 * File  : set.cc   
 * Desc. : STL string set manipulation functions
 *         See e.g. "Using the STL, The C++ Standard Template 
 *         Library" by Robert Robson, sec. edit., Springer, 1999
 *         for an in depth discussion of these algorithms.
 * Author: Rune M. Jensen
 * Date  : 10/23/00
 ******************************************************/

#include<string>
#include<set>
#include<algorithm>
#include<stream.h>

using namespace std;

void strprint(set<string> s) {
  set<string>::iterator i;

  for (i= s.begin(); i != s.end(); ++i)
    cout << *i << " ";
}

// set member
bool strmember(set<string> s,string e) {

  if (s.find(e) == s.end() )
    return false;
  else
    return true;
}

// set union
set<string> strunion(set<string> s1,set<string> s2) {

  set<string> res;
  insert_iterator< set<string> > res_ins(res, res.begin());

  set_union(s1.begin(),s1.end(),s2.begin(),s2.end(),res_ins);
  return res;
}

// set intersection
set<string> strintersection(set<string> s1,set<string> s2) {

  set<string> res;
  insert_iterator< set<string> > res_ins(res, res.begin());

  set_intersection(s1.begin(),s1.end(),s2.begin(),s2.end(),res_ins);
  return res;
}      

// set difference (s1 - s2
set<string> strdifference(set<string> s1,set<string> s2) {

  set<string> res;
  insert_iterator< set<string> > res_ins(res, res.begin());

  set_difference(s1.begin(),s1.end(),s2.begin(),s2.end(),res_ins);
  return res;
}

// set symmetric difference (union - intersection)
set<string> strsymmetricdifference(set<string> s1,set<string> s2) {

  set<string> res;
  insert_iterator< set<string> > res_ins(res, res.begin());

  set_symmetric_difference(s1.begin(),s1.end(),s2.begin(),s2.end(),res_ins);
  return res;
}
