/****************************************************** 
 * File  : pddlR.h
 * Desc. : Strips PDDL domain and problem data structure
 * Author: Rune M. Jensen
 * Date  : 10/16/00
 ******************************************************/

#ifndef PDDLRH
#define PDDLRH



/****************************************************
 * Domain data structure                            *
 ****************************************************/

typedef struct _arglst {
  char *name; /* variable name or constant name */
  struct _arglst *next; 
} arglst;

typedef struct _predlst {
  char *name;
  arglst *args;
  struct _predlst *next;
} predlst;

typedef struct _litlst {
  char *name;
  int sign; /* 1: literal positive, 0: literal negative */
  arglst *args;
  struct _litlst *next;
} litlst;

typedef struct _actionlst {
  char *name;
  arglst *params;
  litlst *pre;
  predlst *add;
  predlst *del;
  struct _actionlst *next;
} actionlst;

typedef struct _domain {
  char *name;
  predlst *predicates;
  actionlst *actions;
} domain;


/****************************************************
 * Problem data structure                           *
 ****************************************************/

typedef struct _problem {
  char *name;
  arglst *objects;
  predlst *init;
  predlst *goal;
} problem;


/*********** function prototypes ********************/
char *copystr(char *str);
arglst *consarg(arglst *hd, arglst *tl);
arglst *newarg(char *name);
predlst *conspred(predlst *hd,predlst *tl);
predlst *newpred(char *name, arglst *args);
litlst *conslit(litlst *hd,litlst *tl);
litlst *newlit(char *name,int sign,arglst *args);
actionlst *consaction(actionlst *hd,actionlst *tl);
actionlst *newaction(char *name, arglst *params,litlst *pre,predlst *add,predlst *del);
predlst *dellist(litlst *effect);
predlst *addlist(litlst *effect);
void printarglst(arglst *args);
void printpredlst(predlst *preds);
void printlitlst(litlst *lits);
void printactionlst(actionlst *acts);
void printdomain(domain *dom);
void printproblem(problem *prob);


#endif
