#!/usr/local/bin/perl5 -w

## ===========================================================================
##
## nadl2nadlval
## 
## translates an NADL domain to an NADL domain with action values
##
## Rune M. Jensen
## 10/29/00
## 
## input format
## <nadlfileOld> <nadlfileNew>
## ...
## ===========================================================================


$Usage = "$0 <fileOld> <fileNew> \n";

unless (@ARGV==2) { print $Usage and exit(1); }

open(MNP,  "<$ARGV[0].nadl") or die "Unable to read $ARGV[0].nadl: $!";
open(NADL, ">$ARGV[1].nadl") or die "Unable to read $ARGV[1].nadl: $!";

while ($line = <MNP>) {
  if ($line =~ /con:/) {
    print NADL "    val: 1\n"
  }
    $line =~ s/con:/mod:/;
    print NADL $line;

}

close(MNP);
close(NADL);

