#!/usr/local/bin/perl5 -w

## ===========================================================================
##
## mnp2nadl
## 
## translates an MNP domain to NADL
##
## Rune M. Jensen
## 10/29/00
## 
## input format
## <mnpfile> <nadlfile>
## ...
## ===========================================================================


$Usage = "$0 <file> \n";

unless (@ARGV==1) { print $Usage and exit(1); }

open(MNP,  "<$ARGV[0].mnp") or die "Unable to read $ARGV[0].mnp: $!";
open(NADL, ">$ARGV[0].nadl") or die "Unable to read $ARGV[0].nadl: $!";

while ($line = <MNP>) {
    $line =~ s/scalar/nat/;
    $line =~ s/mnp/nadl/;
    $line =~ s/var:/con:/;
    print NADL $line;
}

close(MNP);
close(NADL);

