/****************************************************** 
 * File  : gripper.cc   
 * Desc. : Generator program for mnp n-gripper worlds
 *         domain used in AIPS'98
 * Author: Rune M. Jensen CS, CMU, (IAU, DTU)
 * Date  : 4/5/99
 ******************************************************/

#include <iostream.h>
#include <fstream.h>
#include <stdlib.h>


int main(int argc, char **argv) {
  
  int ballnum,i;

  // check input
  if (argc != 3)
    {
      cout << "Usage: gripper <n> <domain>.mnp\n";
      exit(1);
    }

  ofstream  out(argv[2],ios::out);
  ballnum = atoi(argv[1]);
  
  // write head
  out << "\% File:   " << argv[2] << "\n";
  out << "\% Desc:   AIPS'98 Competition Gripper problem with" << ballnum << " balls\n";
  out << "\% Date:   99\n";
  out << "\% Author: Rune M. Jensen CS, CMU, (IAU, DTU)\n";

  // write variablesVARIABLES
  out << "\nVARIABLES\n";
  out << "  bool fl,fr   \% free left gripper,  free right gripper\n";
  out << "  scalar(1) pr \% position of robot: 0:rooma, 1:roomb\n"; 
  out << "               \% position of balls: 0:rooma, 1:roomb 2:leftgripper 3:rightgripper\n"; 
  out << "  scalar(2) ";
  out << "p0";
  for (i=1; i<ballnum; i++)
    out << ",p" << i;
  out << "\n";

  // write actions
  out << "\nSYSTEM\n";
  out << "\n  agt: Action\n\n";
  
  out << "   MoveRobotA2B\n";
  out << "     var: pr\n";
  out << "     pre: pr = 0\n";
  out << "     eff: pr' = 1\n\n";
  
  out << "   MoveRobotB2A\n";
  out << "     var: pr\n";
  out << "     pre: pr = 1\n";
  out << "     eff: pr' = 0\n\n";

  for (i=0; i<ballnum; i++)
    {
      out << "   PickLeft" << i << "\n";
      out << "     var: fl,p" << i << "\n";
      out << "     pre: fl /\\ p" << i << " = pr\n";
      out << "     eff: ~fl' /\\ p" << i << "' = 2\n\n";
    }

  for (i=0; i<ballnum; i++)
    {
      out << "   PickRight" << i << "\n";
      out << "     var: fr,p" << i << "\n";
      out << "     pre: fr /\\ p" << i << " = pr\n";
      out << "     eff: ~fr' /\\ p" << i << "' = 3\n\n";
    }
  
  for (i=0; i<ballnum; i++)
    {
      out << "   DropLeft" << i << "\n";
      out << "     var: fl,p" << i << "\n";
      out << "     pre: p" << i << " = 2\n";
      out << "     eff: fl' /\\ p" << i << "' = pr\n\n";
    }


  for (i=0; i<ballnum; i++)
    {
      out << "   DropRight" << i << "\n";
      out << "     var: fr,p" << i << "\n";
      out << "     pre: p" << i << " = 3\n";
      out << "     eff: fr' /\\ p" << i << "' = pr\n\n";
    }


  out << "ENVIRONMENT\n\n";

  out << "INITIALLY\n";
  out << "  pr = 0 /\\ fl /\\ fr";
  for (i=0; i<ballnum; i++)
    out << " /\\ p" << i << " = 0";
  out << "\n\n";
  
  out << "GOAL\n";
  out << "  p0 = 1";
  for (i=1; i<ballnum; i++)
    out << " /\\ p" << i << " = 1";
  out << "\n";
}

