/****************************************************** 
 * File  : main.cc   
 * Desc. : PDDL NADL translator for AIPS-2000 
 *         Blocks domain (Track1, untyped
 *         base set (does not handle additional set))
 * Author: Rune M. Jensen
 * Date  : 11/10/00
 ******************************************************/
#include <stream.h>
#include <fstream.h>
#include <string.h>
#include <stdio.h> 
#include <stdlib.h>
#include <math.h>
#include <map>
#include <set>
#include <string>
#include "set.h"
#include "common.h"
#include "pddlRcpp.h"
#include "main.h"

// globals used by LEX/YACC parsing
domain *dom;
problem *prob;


void  printusage() {
  printf("USAGE:\n");
  printf("       -p <problem name>               (default prob)\n");  
  printf("       -h print usage\n");
  printf("      ");
  printf("\n");
}



int numberof(char *str) {
  char  buf[512];
  char *p;
  strcpy(buf,str);
  p = &buf[3];
  
  return atoi(p);
}


char *nameof(char *str) {
  char *buf;
  char *p;
  buf = new char[512];
  strcpy(buf,str);
  buf[3] = '\0';
  
  return buf;
}
  



int main(int argc,char **argv)  {
  extern FILE *yyin;
  extern int yylineno;


  // input parameters
  char pddlname[MAXNAMELENGTH];
  char nadlname[MAXNAMELENGTH];
  char name[MAXNAMELENGTH]  = "prob";

  int ind,i,j;


  if (argc < 2) {
    printusage();
    exit (-1);
  }


  /*** Scan command line ***/
  for (ind = 1; ind < argc; ind++) {

    /*** Parse switches ***/
    if (argv[ind][0] == '-') {
      switch (argv[ind][1]) {  
      case 'h':   printusage(); exit(0);
	break;
      case 'p': strcpy(name,argv[++ind]);
	break;
      default : printf("Unknown switch '%c'\n", argv[ind][1]);
	break;
      }
    }
  }


  sprintf(pddlname,"%s.pddl",name);
  sprintf(nadlname,"%s.nadl",name);
  

  /*** allocate domain and problem structures **/
  dom =  new domain;
  prob = new problem;

  /*** parse PDDL problem ***/
  if ( (yyin = fopen(pddlname,"r")) == NULL)
    {
      cout << "Cannot open \"" << pddlname << "\"\n"; 
      exit(-1);
    }

  cout << "parsing : " << pddlname << "\n";
  yylineno = 0;
  if (yyparse()) exit(-1); 

  // debug
  // cout << "PDDL PROBLEM :\n";
  // printproblem(prob);
   


  // 
  map<string,int> blocksmap;
  set<string> blocks;


  int blocknum = 0;
  
  // go through init and instantiate maps;
  for (arglst* pl = prob->objects; pl != NULL; pl = pl->next) {
    blocksmap[pl->name] = blocknum++;
      blocks.insert(pl->name);
  }




  ofstream out(nadlname,ios::out);
  out << "\% File : " << nadlname << endl;
  out << "\% Desc : Translation of AIPS-00 Track 1, untyped, blocks problem\n";
  out << "\%        " << pddlname << endl;
  out << "\% Date : 11/00\n";
  out << "\% Auth : Rune M. Jensen CS, CMU\n\n\n";
  
  out << "VARIABLES\n";
  
  out << "\n   nat(" << int(ceil(log(blocknum+2)/log(2))) << ") ";
  for (i = 0; i < blocknum; i++) {
    out << "posblock" << i+1;
    if (i < blocknum-1) out << ", ";
  }
  
  // block positions are ordered 
  // ...
  // 3: on block B - 2
  // 2: on block A - 1
  // 1: on table
  // 0: in grapper
  
  
  out << "\n\nSYSTEM\n\n";
  out << "  agt: sys\n\n";
  
  
  
  
  for (i=0; i<blocknum; i++)   // package number
    {
      out << "  pick_upBlock" << i+1 << endl;
      out << "    con: posblock" << i+1 << endl;
      out << "    pre: ";
      for (j=0; j<blocknum; j++) {
	if (j != 0) out << " /\\ ";
	if (i != j)
	  out << "posblock" << j+1 << " > 0 /\\ posblock" << j+1 << " <> " << i+2;
	else
	  out << "posblock" << j+1 << " = 1";
      }
      
      out << endl;
      out << "    eff: posblock" << i + 1 << "' = 0\n\n";
    }



 for (i=0; i<blocknum; i++)   // block
     {
       out << "  put_downBlock" << i+1 << endl;
       out << "    con: posblock" << i+1 << endl;
       out << "    pre: posblock" << i+1 << " = 0\n";
       out << "    eff: posblock" << i + 1 << "' = 1\n\n";
     }


 for (i=0; i<blocknum; i++)   // block1
   for (j=0; j<blocknum; j++)   // block2
     if (i != j)
       {
	 out << "  stackBlock" << i+1 << "onBlock" << j+1 << endl;
	 out << "    con: posblock" << i+1 << endl;
	 out << "    pre: "; 
	 int notfirst = 0; 
	 for (int k=0; k<blocknum; k++) {
	   if (k == i)
	     {
	       if (notfirst) out << " /\\ ";
	       out << "posblock" << i+1 << " = 0";
	       notfirst = 1;
	     }
	   else if (k != j)
	     {
	       if (notfirst) out << " /\\ ";
	       out << "posblock" << k+1 << " <> " << j+2;
	       notfirst = 1;
	     }
	   
	 }
	 out << endl;
	 out << "    eff: posblock" << i + 1 << "' = " << j+2 << "\n\n";
       }




 for (i=0; i<blocknum; i++)   // block1
   for (j=0; j<blocknum; j++)   // block2
     if (i != j)
       {
	 out << "  unstackBlock" << i+1 << "fromBlock" << j+1 << endl;
	 out << "    con: posblock" << i+1 << endl;
	 out << "    pre: "; 
	 int notfirst = 0; 
	 for (int k=0; k<blocknum; k++) {
	   if (k == i)
	     {
	       if (notfirst) out << " /\\ ";
	       out << "posblock" << i+1 << " = " << j+2;
	       notfirst = 1;
	     }
	   else  
	     {
	       if (notfirst) out << " /\\ ";
	       out << "posblock" << k+1 << " <> " << i+2 << " /\\ posblock" << k+1 << " > 0 ";
	       notfirst = 1;
	     }
	   
	 }
	 out << endl;
	 out << "    eff: posblock" << i + 1 << "' = 0\n\n";
       }





 
 out << "ENVIRONMENT\n \nINITIALLY\n";

 int flag;
 flag  = 0;
 
  for (predlst* pl = prob->init; pl != NULL; pl = pl->next)
    {
      if (!strcmp(pl->name,"ON") || !strcmp(pl->name,"ONTABLE")) {
	if (flag) out << " /\\ "; 
	flag = 1;
	if (!strcmp(pl->name,"ON"))
	  out << "posblock" << blocksmap[pl->args->name]+1 << " = " 
		 << blocksmap[pl->args->next->name]+2;
	
	if (!strcmp(pl->name,"ONTABLE"))
	  out << "posblock" << blocksmap[pl->args->name]+1 << " = 1"; 
      }
    }
	

  out << "\n\nGOAL\n";

 flag  = 0;
  
  for (predlst* pl = prob->goal; pl != NULL; pl = pl->next)
    {
      if (!strcmp(pl->name,"ON") || !strcmp(pl->name,"ONTABLE")) {
	if (flag) out << " /\\ "; 
	flag = 1;
	if (!strcmp(pl->name,"ON"))
	  out << "posblock" << blocksmap[pl->args->name]+1 << " = " 
		 << blocksmap[pl->args->next->name] + 2;
	
	if (!strcmp(pl->name,"ONTABLE"))
	  out << "posblock" << blocksmap[pl->args->name]+1 << " = 1"; 
      }
    }

       
  return 0;
    }
