;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; 4 Op-blocks world
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (domain BLOCKS)
  (:requirements :strips)
  (:predicates (ON ?x ?y)
	       (ONTABLE ?x)
	       (CLEAR ?x)
	       (HANDEMPTY)
	       (HOLDING ?x)
	       )

  (:action pick-up
	     :parameters (?x)
	     :precondition (and (CLEAR ?x) (ONTABLE ?x) (HANDEMPTY))
	     :effect
	     (and (not (ONTABLE ?x))
		   (not (CLEAR ?x))
		   (not (HANDEMPTY))
		   (HOLDING ?x)))

  (:action put-down
	     :parameters (?x)
	     :precondition (HOLDING ?x)
	     :effect
	     (and (not (HOLDING ?x))
		   (CLEAR ?x)
		   (HANDEMPTY)
		   (ONTABLE ?x)))
  (:action stack
	     :parameters (?x ?y)
	     :precondition (and (HOLDING ?x) (CLEAR ?y))
	     :effect
	     (and (not (HOLDING ?x))
		   (not (CLEAR ?y))
		   (CLEAR ?x)
		   (HANDEMPTY)
		   (ON ?x ?y)))
  (:action unstack
	     :parameters (?x ?y)
	     :precondition (and (ON ?x ?y) (CLEAR ?x) (HANDEMPTY))
	     :effect
	     (and (HOLDING ?x)
		   (CLEAR ?y)
		   (not (CLEAR ?x))
		   (not (HANDEMPTY))
		   (not (ON ?x ?y)))))
