/*

assumptions:
zero point is the upperleft coner.

command:
1. region mcc2-45.net output.dat
or
2. region mcc2-45.net output.dat lowerleft_x lowerleft_y height length 
percentage_to_drop seed

I also generate a temp.m file. If you run matlab, you can see the plot.

I didn't do much test. There may be bugs. Let me know.
Anyway, this benchmark is not of any help now.

*/

#include <stream.h>
#include <fstream.h>
#include <stdlib.h>

#define MAXNETINREGION 1000
#define MAXNET 10000
#define LLX 0
#define LLY 1
#define URX 2
#define URY 3

//generate a random number x that 0 <= x < n
int rd(int n){
  int y=int(random())%n;
  return y;
}

class clsnetcount{
public:
  int count;
  int maxcount;
  int netid[MAXNETINREGION];
  int drop[MAXNETINREGION];
  clsnetcount(int n){
    maxcount=n;
    count=0;
    for(int i=0;i<maxcount;i++)
      netid[i]=drop[i]=0;
  }
  clsnetcount(){
    maxcount=MAXNETINREGION;
    count=0;
    for(int i=0;i<maxcount;i++)
      netid[i]=drop[i]=0;
  }
  void add(int id){
    for(int i=0;i<count;i++)
      if(netid[i]==id) return;
    netid[count]=id;
    count++;
  }
  //randomly drop one
  int dropone(){
    int i=rd(count);
    for(;drop[i];i=rd(count));
    drop[i]=1;
    return netid[i];
  }
  //check if dropped
  int dropped(int id){
    if (id==0) return 0;
    for(int i=0;i<count;i++)
      if(drop[i] && netid[i]==id){
	return 1;
      }
    return 0;
  }
};


main(int argc, char * argv[]){

  ifstream in(argv[1]);
  if(!in){
    cout<<"can not open "<<argv[1]<<"!\n";
    return 1;
  }

  int chip_xsize, chip_ysize;
  char ch;
  //read in the size of the chip
  //from the second to the last line
  in.seekg(-6, ios::end);
  for(ch=in.peek();ch!='\n';){
    in.seekg(-1, ios::cur);
    ch=in.peek();
  }
  int x, y, z, netid;
  in>>chip_xsize>>chip_ysize>>z>>netid;
  chip_xsize++;
  chip_ysize++;
  if(z!=0 || netid!=0){
    cout<<"input format error!\n";
    return 1;
  }
  cout<<"chip_xsize : "<<chip_xsize<<";  chip_ysize : "<<chip_ysize<<endl;
  int lowerleft_x=0, lowerleft_y=0; 
  int height=0, length=0;
  int percent=0,seed=0;
  if(argc==3){
    cout<<"please give me the lower left corner of the target region (x(0 to "<<chip_xsize-1<<"), y(0 to "<<chip_ysize-1<<")) : ";
    cin>>lowerleft_x>>lowerleft_y;
    cout<<"please give me the height and length of the target region (h(1 to "<<lowerleft_y+1<<", l(1 to "<<chip_xsize-lowerleft_y+1<<")) : ";
    cin>>height>>length;
    cout<<"please give me the percentage to drop nets (0 to 100) : ";
    cin>>percent;
    cout<<"please give me a random number as the seed to decide which net I will drop :";
    cin>>seed;
  }
  else if(argc==9){
    lowerleft_x=atoi(argv[3]);
    lowerleft_y=atoi(argv[4]);
    height=atoi(argv[5]);
    length=atoi(argv[6]);
    percent=atoi(argv[7]);
    seed=atoi(argv[8]);
  }
  int upperright_x=lowerleft_x+length-1;
  int upperright_y=lowerleft_y-height+1;
  //  cout<<lowerleft_x<<" "<<lowerleft_y<<" "<<upperright_x<<" "<<upperright_y<<endl;

  in.seekg(0, ios::beg);
  
  int region[length][height];
  for(int i=0;i<length;i++)
    for(int j=0;j<height;j++)
      region[i][j]=0;
  int bbox[MAXNET][4];
  for(int i=0;i<MAXNET;i++){
    bbox[i][LLX]=upperright_x;
    bbox[i][LLY]=upperright_y;
    bbox[i][URX]=lowerleft_x;
    bbox[i][URY]=lowerleft_y;
  }
  clsnetcount netcount;
  in>>x>>y>>z>>netid;
  for(int i=0;netid!=0;i++){
    //if within the target region
    if(x>=lowerleft_x && x<=upperright_x && y>=upperright_y && y<=lowerleft_y){
      region[x-lowerleft_x][y-upperright_y]=netid;
      netcount.add(netid);
    }
    //update the bounding box
    if(x<bbox[netid][LLX]) bbox[netid][LLX]=lowerleft_x;
    if(y>bbox[netid][LLY]) bbox[netid][LLY]=lowerleft_y;
    if(x>bbox[netid][URX]) bbox[netid][URX]=upperright_x;
    if(y<bbox[netid][URY]) bbox[netid][URY]=lowerleft_y;
    in>>x>>y>>z>>netid;
  }
  in.close();

  //drop nets according to the percent
  int netdrop=(netcount.count)*percent/100;
  cout<<"There are "<<netcount.count<<" nets in the target region. Will drop "<<netdrop<<" nets.\n";
  srandom(seed);
  for(int i=0;i<netdrop;i++)
    netcount.dropone();
  for(int i=0;i<length && netdrop!=0;i++)
    for(int j=0;j<height && netdrop!=0 ;j++){
      if(netcount.dropped(region[i][j])){
	region[i][j]=0;
      }
    }

  //add connection pins according to bounding box
  for(int i=0;i<netcount.count;i++){
    if(netcount.drop[i]) continue;
    netid=netcount.netid[i];
    if(bbox[netid][LLY]>=lowerleft_y){ //add a pin at lower edge
      clsnetcount nonocupy(bbox[netid][URX]-bbox[netid][LLX]+1);
      for(int j=bbox[netid][LLX]-lowerleft_x;j<bbox[netid][URX]-lowerleft_x;j++){
	if(region[j][0]==netid) break;
	if(region[j][0]==0) nonocupy.add(j);
      }
      if(nonocupy.count>0) region[nonocupy.dropone()][0]=netid;
      //if can not find a empty grid within the bounding box, simply give up
    }
    if(bbox[netid][URY]<=upperright_y){ //add a pin at upper edge
      clsnetcount nonocupy(bbox[netid][URX]-bbox[netid][LLX]+1);
      for(int j=bbox[netid][LLX]-lowerleft_x;j<bbox[netid][URX]-lowerleft_x;j++){
	if(region[j][height-1]==netid) break;
	if(region[j][height-1]==0) nonocupy.add(j);
      }
      if(nonocupy.count>0) region[nonocupy.dropone()][height-1]=netid;
      //if can not find a empty grid within the bounding box, simply give up
    }
    if(bbox[netid][LLX]<=lowerleft_x && bbox[netid][URY]>upperright_y && bbox[netid][LLY]<lowerleft_y){ //add a pin at left edge
      clsnetcount nonocupy(bbox[netid][LLY]-bbox[netid][URY]+1);
      for(int j=bbox[netid][URY]-upperright_y;j<bbox[netid][LLY]-upperright_y;j++){
	if(region[0][j]==netid) break;
	if(region[0][j]==0) nonocupy.add(j);
      }
      if(nonocupy.count>0) region[0][nonocupy.dropone()]=netid;
      //if can not find a empty grid within the bounding box, simply give up
    }
    if(bbox[netid][URX]>=upperright_x && bbox[netid][URY]>upperright_y && bbox[netid][LLY]<lowerleft_y){ //add a pin at right edge
      clsnetcount nonocupy(bbox[netid][LLY]-bbox[netid][URY]+1);
      for(int j=bbox[netid][URY]-upperright_y;j<bbox[netid][LLY]-upperright_y;j++){
	if(region[length-1][j]==netid) break;
	if(region[length-1][j]==0) nonocupy.add(j);
      }
      if(nonocupy.count>0) region[length-1][nonocupy.dropone()]=netid;
      //if can not find a empty grid within the bounding box, simply give up
    }
  }

    //output result
    ofstream out(argv[2]);
    ofstream out2("temp.m");
    out2<<"a=[\n";
    out<<length<<" "<<height<<endl;
    for(int i=0;i<length;i++){
      for(int j=0;j<height;j++){
	out<<region[i][j]<<" ";
	if(region[i][j]!=0) out2<<i<<" "<<j<<endl;
      }
      out<<endl;
    }
    out.close();
    out2<<"];\n";
    out2<<"x=a(:,1);y=a(:,2);plot(x,y,'o')\n";
    out2.close();
}
