///////////////////////////////////////////
// File : main.cc  
// Desc : translation program from Kunz/Sulimma
//        benchmarks to benchmarks as used by the channel
//        router.
// Auth : Rune M. Jensen
// Date : 03/21/02
///////////////////////////////////////////

#include <stream.h>
#include <stdio.h> 
#include <stdlib.h>
#include <set>
#include "set.hpp"


using namespace std;


// command
//  translate <infile> <outfile> <tracknum>

int main(int argc,char **argv)  {

  if (argc < 4)
    {
      cout << "Command: translate <infile> <outfile> <tracknum>\nexiting\n";
      exit(-1);
    }
  

  FILE *in;   
  if ( (in = fopen(argv[1],"r")) == NULL)
    {
      cout << "main.cc : Cannot open \"" << argv[1] << "\"\n"; 
      exit(-1);
    }

  int columnnum,dum;
  fscanf(in,"%i %i %i\n",&columnnum,&dum,&dum);

  int **column = new int*[columnnum];
  for (int i = 0; i < columnnum; i++)
    column[i] = new int[2]; 
    
  for (int i = 0; i < columnnum; i++)
    fscanf(in,"%i %i\n",&column[i][0],&column[i][1]);

 
  // find live ranges
  set<int> isborn;
  set<int> *born = new set<int>[columnnum];
  for (int i = 0; i < columnnum; i++)
    for (int j = 0; j < 2; j++)
      if (column[i][j] > 0)
	if (!setmember(isborn,column[i][j]))
	  {
	    isborn.insert(column[i][j]);
	    born[i].insert(column[i][j]);
	  }
	  
  set<int> isdead;
  set<int> *dead = new set<int>[columnnum];
  for (int i = columnnum - 1 ; i >= 0 ; i--)
    for (int j = 0; j < 2; j++)
      if (column[i][j] > 0)
	if (!setmember(isdead,column[i][j]))
	  {
	    isdead.insert(column[i][j]);
	    dead[i].insert(column[i][j]);
	  }

  set<int> *live = new set<int>[columnnum];
  for (int i = 0; i < columnnum; i++)
    {
      if (i > 0) live[i] = setdifference(live[i-1],dead[i-1]);
      for (set<int>::iterator si = born[i].begin(); si != born[i].end(); ++si)
	  live[i].insert(*si);
    }


  // count max number of live nets
  int maxlive = 0;
  set<int> nolivecol;
  for (int i = 0; i < columnnum; i++)
    {
      if (live[i].size() > maxlive) maxlive = live[i].size();
      if (live[i].size() == 0) 
	{
	  cout << "col " << i << " has no live nets and is removed\n";
	  nolivecol.insert(i);
	}
    }

  int tracknum = atoi(argv[3]);
  
  cout << "Max number of live nets on a column=" << maxlive << endl;

  if (tracknum < maxlive) 
    {
      cout << "Too few tracks\nexiting\n";
      exit(-1);
    }
  
  // generate output
  int netnum = isborn.size();
  
  FILE *out;   
  if ( (out = fopen(argv[2],"w")) == NULL)
    {
      cout << "main.cc : Cannot open \"" << argv[1] << "\"\n"; 
      exit(-1);
    }

  fprintf(out,"%i %i %i\n\n",columnnum - nolivecol.size(),tracknum,netnum);
  
  for (int i = 0; i < columnnum; i++)
    if (!setmember(nolivecol,i))
      for (int j = 0; j < tracknum; j++)
	if (j == 0)     
	  fprintf(out,"%i",column[i][0]);
	else if (j == tracknum - 1)
	  fprintf(out," %i\n",column[i][1]);
	else
	  fprintf(out," 0");
  
}
