#include <stdlib.h>
#include <stream.h>
#include <fstream.h>

/*
Hello Rune,

I put the benchmark generator and input files here:
www.ece.cmu.edu/~huix/for_Rune
Just run it as
    benchmark input input.out output_filename
"input" could be primary1, primary2 or industry1
There are 3 integer parameters:

   whole chip area, divide into global grid
       -----------------------------
       |   |   |   |   |   |   |   |
       -----------------------------
       |   |   |   |   |   |   |   |   <-- integer 1
       -----------------------------   (work on which row)
       |   |   |   |   |   |   |   |
       -----------------------------
       |   |   |   |   |   |   |   |
       -----------------------------
       |   |   |   |   |   |   |   |
       -----------------------------

integer 2 and 3, divide each global grid into how many columns and
rows.
So the integer 3 is the number of tracks. You can always make it large
enough so that the channel is routable.

Btw, did you received the Deutch benchmark I send you days ago?

Best regards,
 Hui                            mailto:huix@andrew.cmu.edu
*/



//the chip is at most a MaxSize by MaxSize G-grid area.
//G-grid : "big" grid for global placement
#define MaxSize 25
#define MaxTracks 20

//generate a random number x that 0 <= x < n
int rd(int n){
  int y=int(random())%n;
  return y;
}

int alreadyin(int pins[][MaxSize], int x, int tempi){
  for(int k=0;k<pins[0][x];k++)
    if(tempi==pins[k+1][x]) return 1;
  return 0;
  /*
  if(x!=0)
    for(int k=0;k<pins[0][x-1];k++)
      if(tempi==pins[k+1][x-1]) return 1;
  if(x!=11)
    for(int k=0;k<pins[0][x+1];k++)
      if(tempi==pins[k+1][x+1]) return 1;
  return 0;
  */
}

void place(int pins[][MaxSize], int col, int ocupy[][MaxTracks], int xsize, int ysize){
  int cap=xsize*ysize;
  int num,x,y;

  for(int i=1;i<=pins[0][col];i++){
    num=rd(cap);
    x=num%xsize;
    y=num/xsize;

    for(;((ocupy[x][y]!=0)&&(num<cap));){
      num++;
      x=num%xsize;
      y=num/xsize;
    }

    for(;((ocupy[x][y]!=0)&&(num>=0));){
      num--;
      x=num%xsize;
      y=num/xsize;
    }

    ocupy[x][y]=pins[i][col];

  }
}

int single(int pins[][MaxSize], int x, int y){

  int f=1;

  for(int i=1;(i<MaxSize && f);i++){
    if(i==y) continue;
    for(int j=1;j<=pins[0][i] && f;j++){
      if(pins[x][y]==pins[j][i])
	f=0;
    }
  }

  return f;
}

void remove(int pins[][MaxSize], int x, int y){

  pins[0][y]--;
  for(int j=x;j<=pins[0][y];j++)
    pins[j][y]=pins[j+1][y];
}

int checksingle(int pins[][MaxSize]){

  int netindex[200];
  int numofnet=0;

  for(int i=1;i<MaxSize;i++)
    for(int j=1;j<=pins[0][i];j++){
      //if already in netindex
      int withinnetindex=0;
      for(int k=0;k<numofnet;k++)
	if(pins[j][i]==netindex[k])
	  withinnetindex=1;
      if(withinnetindex) continue;
      //else check if single
      if(single(pins,j,i)){
	remove(pins,j,i);
	j--;
      }
      else{
	netindex[numofnet]=pins[j][i];
	numofnet++;
      }
    }

  //change index
  for(int i=1;i<MaxSize;i++)
    for(int j=1;j<=pins[0][i];j++){
      int k;
      for(k=0;k<numofnet;k++){
	if(pins[j][i]==netindex[k])
	  break;
      }
      k++;
      pins[j][i]=k;
    }

  return numofnet;

}


//command input1 input2 output
main(int argc, char * argv[]){

  //input file 1 tells the connection information of pins.
  ifstream in1(argv[1]);
  //input file 2 tells the global position of pins.
  ifstream in2(argv[2]);

  //pins in a G-grid
  //pins[0][] is the number of pins in the current G-grid
  int pins[100][MaxSize];

  int ColSize=0;
  in1>>ColSize;

  for(int i=0;i<MaxSize;i++){
    pins[0][i]=0;
  }

  int YY=1;
  cout<<"generate data for which row? (1 to "<<ColSize-2<<") : ";
  cin>>YY;

  //get over extra data
  int tempi;
  float tempf;
  for(int i=0;i<3;i++)
    in1>>tempi;
  for(int i=0;i<2;i++)
    in1>>tempf;

  //generate pins[][]
  int ngates,nnets;
  in1>>ngates>>nnets;
  int x,y;
  int ngnet;
  for(int i=0;i<ngates;i++){
    in2>>tempi>>x>>y;
    in1>>tempi>>ngnet;
    for(int j=0;j<ngnet;j++){
      in1>>tempi;
      if(y==YY)
	if(!alreadyin(pins, x, tempi))
	  pins[++pins[0][x]][x]=tempi;
    }
  }


  in1.close();
  in2.close();

  //ignore long lines (lines that only have a single pin in the current row)
  int numofnet=checksingle(pins);

  for(int i=1;i<ColSize-1;i++)
    cout<<"col "<<i<<" -- num of pins: "<<pins[0][i]<<endl;

  int xsize, ysize;
  cout<<"divide each G-grid into how many columns? : ";
  cin>>xsize;
  cout<<"divide each G-grid into how many rows? (number of tracks) : ";
  cin>>ysize;

  //output 
  ofstream out(argv[3]);

  int ocupy[xsize][MaxTracks];
  for(int i=0;i<xsize;i++)
    for(int j=0;j<ysize;j++)
      ocupy[i][j]=0;

  out<<(ColSize-2)*xsize<<" "<<ysize<<" "<<numofnet<<endl<<endl;

  for(int k=1;k<ColSize-1;k++){
    place(pins, k, ocupy, xsize, ysize);
    for(int i=0;i<xsize;i++){
      for(int j=0;j<ysize;j++){
	out<<ocupy[i][j]<<" ";
	ocupy[i][j]=0;
      }
      out<<endl;
    }
  }
  out.close();
  
}
