function y = ugauss (sigma, k)

%  Ugauss(sigma,k) -- Generate a unit-area gaussian envelope
%	sigma -- standard deviation
%	k -- number of sigmas to generate [6]

if nargin < 1,
	error ('Gauss requires an input sigma');
end;
if nargin < 2,
	k = 6;
end;

x = [-k*sigma/2:k*sigma/2];
y = exp(-(x.^2) ./ (2*sigma^2));
y = y / sum(y);
end;

% This software provided by Mark Maimone (mwm@cmu.edu) as part of his Ph.D.
% thesis.  For more info, please see http://www.cs.cmu.edu/~mwm/thesis
%
% Release Date: 9 October 1997
%
% 	Carnegie Mellon University and the individuals associated with this
% project assume no liability for the fitness or performance of this software
% or any damages resulting from its use.  It's free, you get what you pay
% for...
