function y = spec(x,winsize)
%SPEC Calculate spectrogram from signal.
%	Y = SPEC(A,WINSIZE) calculates the spectrogram
%	for the signal in vector A.  The number of frequencies will be
%       one more than the windowsize.
%	The columns of B contain spectrum estimates as a function of time.
%	Time increases linearly across the columns, starting at column 1.
%	Frequency increases linearly down the rows, starting at 0.
%	We use the Hanning window, which you can replace with any
%	other window of interest by editing specgram.m in
%       /usr/local/pkg/matlab.

y = specgram(x,winsize+1,winsize);

% This software provided by Mark Maimone (mwm@cmu.edu) as part of his Ph.D.
% thesis.  For more info, please see http://www.cs.cmu.edu/~mwm/thesis
%
% Release Date: 9 October 1997
%
% 	Carnegie Mellon University and the individuals associated with this
% project assume no liability for the fitness or performance of this software
% or any damages resulting from its use.  It's free, you get what you pay
% for...
