function y = show6 (mat, freqs)
%
%	show6 (mat, freqs) -- Display magnitude of six 1D gabor filters
%				applied to the input matrix
%
%		mat -- source image

if nargin < 1,
  error ('Must input an image')
end

if nargin < 2,
  freqs = 1 ./ (2 .^[1 2 3 4 5 6]);
end

[ma mb] = size(mat);

clf
for i = 1:min(6,length(freqs)),
  subplot(2,3,i)
  g=gabor(freqs(i), 6, 4);
  im = abs(conv2(mat,g,'same')) .^ .3;
  mask = floor(length(g)/2);
  im(:,1:mask) = zeros(ma,mask);
  im(:,(mb+1-mask):mb) = zeros (ma,mask);
  img(-im,0); title([int2str(floor(1/freqs(i))) ' pixels']);
  set(gca,'YTick',[floor(ma/2) ma]);
  set (gca,'XTick', []);
  ['Completed image ' int2str(i)]
end

% This software provided by Mark Maimone (mwm@cmu.edu) as part of his Ph.D.
% thesis.  For more info, please see http://www.cs.cmu.edu/~mwm/thesis
%
% Release Date: 9 October 1997
%
% 	Carnegie Mellon University and the individuals associated with this
% project assume no liability for the fitness or performance of this software
% or any damages resulting from its use.  It's free, you get what you pay
% for...
