function y = saferecip (x, limit)

% saferecip(x,limit) -- Return the reciprocal, but zero any values within
%	+/-limit (default .001)
%

if nargin < 1,
	error ('You must provide some input!');
end;
if nargin < 2,
	limit = .001;
end;

toohigh = (abs(x) < limit);
x = toohigh .* (100000*ones(size(x))) + (~toohigh) .* x;
y = 1 ./ x;
end;

% This software provided by Mark Maimone (mwm@cmu.edu) as part of his Ph.D.
% thesis.  For more info, please see http://www.cs.cmu.edu/~mwm/thesis
%
% Release Date: 9 October 1997
%
% 	Carnegie Mellon University and the individuals associated with this
% project assume no liability for the fitness or performance of this software
% or any damages resulting from its use.  It's free, you get what you pay
% for...
