function y = refine(m,peaks)
%
%	Refine (matrix, peaks)
%
%		Refine disparity estimates by fitting polynomials
%
%	See also   finddsmin, showdspeaks, mwm.

if (nargin < 2),
  error ('Refine:  two arguments required')
end;

[prows pcols] = size(peaks);
[mrows mcols] = size(m);
y = zeros (prows, pcols);

for r=1:prows;
  for c=1:pcols;
    p = peaks(r,c);
    if p > 0,
      lo = max(peaks(r,c) - 2,1);
      hi = min(peaks(r,c) + 2,mrows);
      while ((lo < peaks(r,c)) & (m(lo,c) <= 0)),
	lo = lo + 1;
      end;
      while ((hi > peaks(r,c)) & (m(hi,c) <= 0)),
	hi = hi - 1;
      end;
      poly = polyfit([lo:hi]',m(lo:hi,c),min(2,hi-lo));

%%%  new estimate is where the derivative is zero

      y(r,c) = -poly(2) / (2 * poly(1));
      if abs(y(r,c)-peaks(r,c)) > 1,
	[j y(r,c)] = min(m(lo:hi,c));
	y(r,c) = y(r,c) + lo - 1;
      end;
    end;
  end;
end;

end;

% This software provided by Mark Maimone (mwm@cmu.edu) as part of his Ph.D.
% thesis.  For more info, please see http://www.cs.cmu.edu/~mwm/thesis
%
% Release Date: 9 October 1997
%
% 	Carnegie Mellon University and the individuals associated with this
% project assume no liability for the fitness or performance of this software
% or any damages resulting from its use.  It's free, you get what you pay
% for...
