function y = mod(mat, scalar)

% Mod(mat, scalar) -- Returns the modulus of matrix elements relative to
%		      scalar

[a b] = size(scalar);
if (nargin < 2),
	error ('mod: Two arguments required: matrix, scalar');
end;

if (a ~= 1 | b ~= 1),
	error ('mod: second argument must be scalar');
end;

y = mat - scalar .* floor (mat / scalar);
end;

% This software provided by Mark Maimone (mwm@cmu.edu) as part of his Ph.D.
% thesis.  For more info, please see http://www.cs.cmu.edu/~mwm/thesis
%
% Release Date: 9 October 1997
%
% 	Carnegie Mellon University and the individuals associated with this
% project assume no liability for the fitness or performance of this software
% or any damages resulting from its use.  It's free, you get what you pay
% for...
