function y = mkmask(a,b,c,d,e)
%	MkMask -- Create a binary mask appropriate for Photometrics
%		  camera output.
%
%	mkmask(radius) -- Reset the radius (default 240)
%	mkmask(xc,yc) -- Reset the center of the image (default [270,203])
%	mkmask(radius,xc,yc)
%	mkmask(xc,yc,xsize,ysize) -- Reset the size of the image [576,384]
%	mkmask(radius,xc,yc,xsize,ysize)

radius = 240;
xc = 270;
yc = 203;
xsize = 576;
ysize = 384;

if (nargin == 1),
	radius = a;
end;

if (nargin == 2),
	xc = a; yc = b;
end;

if (nargin == 3),
	radius = a;
	xc = b; yc = c;
end;

if (nargin == 4),
	xc = a; yc = b; 
	xsize = c; ysize = d;
end;

if (nargin == 5),
	radius = a; xc = b; yc = c;
	xsize = d; ysize = e;
end;

if (nargin > 5),
	error('mkmask:  too many arguments!');
end;

y = fcircle(radius, xc, yc, xsize, ysize);

end;

% This software provided by Mark Maimone (mwm@cmu.edu) as part of his Ph.D.
% thesis.  For more info, please see http://www.cs.cmu.edu/~mwm/thesis
%
% Release Date: 9 October 1997
%
% 	Carnegie Mellon University and the individuals associated with this
% project assume no liability for the fitness or performance of this software
% or any damages resulting from its use.  It's free, you get what you pay
% for...
