function y = kuglin (l,r)

% Kuglin -- Perform the Kuglin-Hines Phase Correlation Image Alignment Method
% 	 -- This method computes the global translation between a pair of
%	    images.  The method is described in Kuglin, C.D. and Hines, D.C.
%	    "The Phase Correlation Image Alignment Method", Proc of the IEEE
%	    1975 Int. Conf. on Cybernetics and Society, Sept 1975, pp 163-165

%	Please send updates/bug fixes to Mark Maimone (mwm@cs.cmu.edu)

if nargin < 2,
	error ('You must supply a left and right image');
end;
[  row  col ] = size (l);
[ rrow rcol ] = size (r);
if (row ~= rrow | col ~= rcol),
	error ('Left and right images must have same dimensions!');
end;

L = fft2(l);
R = fft2(r);
diff = angle(L)-angle(R);
z = exp (i*diff);
kuglin = ifft2(z);

%%%  Find the peak in each column (result is which row has max)
[rowmax, rowind] = max(kuglin);

%%%  Find the overall best
[allmax, colind] = max(rowmax);

y = [rowind(colind) colind] - 1;

%%%  Handle wraparound; large indices denote negative shifts
%%%  The weirdness here is to compensate for what happens when the
%%%  input was a vector.  In that case the vector length is always returned
%%%  in the same place, regardless of whether it was a row or column vector.

if (row == 1 | col == 1),
  y = y - (y(1) > col/2) .* [col 0] - (y(2) > row/2) .* [0 row];
else
  y = y - (y(1) > row/2) .* [row 0] - (y(2) > col/2) .* [0 col];
end;
end;

% This software provided by Mark Maimone (mwm@cmu.edu) as part of his Ph.D.
% thesis.  For more info, please see http://www.cs.cmu.edu/~mwm/thesis
%
% Release Date: 9 October 1997
%
% 	Carnegie Mellon University and the individuals associated with this
% project assume no liability for the fitness or performance of this software
% or any damages resulting from its use.  It's free, you get what you pay
% for...
