function func = ipdplot (x,y)
%	ipdplot -- Plot an Ideal Phase Difference curve, connecting
%	only those points that don't wrap around
%
%	ipdplot(y) - Plot the unwrapped ideal phase differences in y
%			assuming linear wavelength sampling
%	ipdplot(x,y) - Plot the unwrapped ideal phase difference in y
%			using the sampling points in x

if (nargin < 1),
  error ('ipdplot:  Must input an unwrapped ideal phase difference vector');
end;

if (nargin < 2),
	y = x;
	x = [2:length(y)+1];
end;

if (length(x) ~= length(y)),
	error ('ipdplot:  vectors must have same length');
end;

k = floor ((y+pi) / (2*pi));
mody = y-2*pi*k;
dk = dx(k);

plot(x,mody,'o');

for i = [1:length(dk)],
	if dk(i) == 0,
		line([x(i) x(i+1)], [mody(i) mody(i+1)]);
	elseif abs(dk(i)) == 1,
		if y(i) > y(i+1),
			sign = 1;
		else
			sign = -1;
		end;
		sign = -dk(i);
		xi = (x(i+1) - x(i)) * (mody(i) + sign * pi) / (y(i) - y(i+1));
		line([x(i) x(i)+xi], [mody(i) (-sign * pi)]);
		line([x(i+1) x(i)+xi], [mody(i+1) (sign * pi)]);
	end;
end;
set(gca,'YLim',[-pi pi]);
set(gca,'XLim',[min(x) max(x)]);
end;

% This software provided by Mark Maimone (mwm@cmu.edu) as part of his Ph.D.
% thesis.  For more info, please see http://www.cs.cmu.edu/~mwm/thesis
%
% Release Date: 9 October 1997
%
% 	Carnegie Mellon University and the individuals associated with this
% project assume no liability for the fitness or performance of this software
% or any damages resulting from its use.  It's free, you get what you pay
% for...
