function y = interpolate2pi(x1,x2,fraction)

% Interpolate2pi(x1,x2,fraction) -- Linearly interpolate between two phases,
%       assuming they are no more than pi apart.  Handles all wrapping
%       problems.  If no fraction is given, 0.5 is assumed

if (size(x1) ~= size(x2)),
	error ('Interpolate2pi: arguments not same size!');
end;
if (nargin < 2),
	error ('Interpolate2pi: need at least two arguments');
end;
if (nargin < 3),
	fraction = 0.5;			% Compute mean by default
end;
if ((fraction < 0) | (fraction > 1)),
	error ('Interpolate2pi:  fraction must be between 0 and 1!');
end;

x1 = mod2pi (x1);
x2 = mod2pi (x2);
pimat = pi * ones(size(x1));		% Both x1 and x2 are the same size

% Compute pairs that can be averaged directly; those in the same region
% (both > pi or both < pi), and those whose difference is less than pi

same = (~xor(x1 < pimat,x2 < pimat)) | abs(x1-x2) < pimat;
x1bigger = x1 > x2;
y = same .* ((1-fraction)*x1+fraction*x2) + (~same) .* ...
	(x1bigger    .* mod2pi((1-fraction)*x1+fraction*(x2+2*pi)) + ...
	 (~x1bigger) .* mod2pi((1-fraction)*(x1+2*pi)+fraction*x2));
end;

% This software provided by Mark Maimone (mwm@cmu.edu) as part of his Ph.D.
% thesis.  For more info, please see http://www.cs.cmu.edu/~mwm/thesis
%
% Release Date: 9 October 1997
%
% 	Carnegie Mellon University and the individuals associated with this
% project assume no liability for the fitness or performance of this software
% or any damages resulting from its use.  It's free, you get what you pay
% for...
