function y = indices2char (samples, len)
%	INDICES2CHAR (samples, len) -- Given a list of indices, create a
%				   characteristic vector with given length.
%		len == max(samples) unless explicitly given.

if nargin < 1,
  error ('indices2char:  must give a list of samples!')
end;

if nargin < 2,
  len = round(max(max(samples)));
end;

if (round(min(min(samples))) < 1) > 0,
  'WARNING [indices2char]:  values less than one will be ignored'
end;

[a b] = size(samples);

if (len > 10000),
  ['WARNING [indices2char]:  Result will have over 10000 rows (' ...
	num2str(len) ')']
end;

result = zeros(len,b);

for c = 1:a,
  for d = 1:b,
    ind = round(samples(c,d));
    if ind > 0 & ind <= len,
	result(ind,d) = 1;
  end;
end;

y = result;
end;

% This software provided by Mark Maimone (mwm@cmu.edu) as part of his Ph.D.
% thesis.  For more info, please see http://www.cs.cmu.edu/~mwm/thesis
%
% Release Date: 9 October 1997
%
% 	Carnegie Mellon University and the individuals associated with this
% project assume no liability for the fitness or performance of this software
% or any damages resulting from its use.  It's free, you get what you pay
% for...
