function y = halve(mat)

%	halve(mat)  --  Generate a 1/2-scale version of this matrix.  The
%		resulting matrix will  have dimension ceil(size/2).  The
%		decimating function applies a 2D gaussian filter (sigma=1)
%		before subsampling.

if nargin < 1,
  error('halve:  Must input a matrix');
end;

[ xlen ylen ] = size (mat);

y = conv2(mat, ugauss2(1,1,2), 'same');
y = y(1:2:xlen, 1:2:ylen);
end;

% This software provided by Mark Maimone (mwm@cmu.edu) as part of his Ph.D.
% thesis.  For more info, please see http://www.cs.cmu.edu/~mwm/thesis
%
% Release Date: 9 October 1997
%
% 	Carnegie Mellon University and the individuals associated with this
% project assume no liability for the fitness or performance of this software
% or any damages resulting from its use.  It's free, you get what you pay
% for...
