function y = gauss (sigma, k, mean)

%  Gauss(sigma,k) -- Generate a gaussian envelope with peak=1
%	sigma -- standard deviation
%	k -- number of sigmas to generate [6]
%	mean -- mean value [sigma k / 2]
%
%  NOTE!!! -- If you don't set the mean, you'll get a shifted but symmetric
%		result.
%	      If you *do* set the mean, the result will be padded down to
%		one and *not* shifted.

if nargin < 1,
	error ('Gauss requires an input sigma');
end;
if nargin < 2,
	k = 6;
end;

xhi = k * sigma / 2;
xlo = -xhi;

if nargin < 3,
	mean = 0;
else
	xlo = 1;
	xhi = mean+xhi;
end;

x = [xlo:xhi];
y = exp(-((x-mean).^2) ./ (2*sigma^2));
end;

% This software provided by Mark Maimone (mwm@cmu.edu) as part of his Ph.D.
% thesis.  For more info, please see http://www.cs.cmu.edu/~mwm/thesis
%
% Release Date: 9 October 1997
%
% 	Carnegie Mellon University and the individuals associated with this
% project assume no liability for the fitness or performance of this software
% or any damages resulting from its use.  It's free, you get what you pay
% for...
