function y = gaborplot (freq, color, number_sigmas, number_periods)
%
%	Gaborplot (frequency, color, number_sigmas, number_periods)
%		Plot the ABS of a Gabor filter with given frequency
%
%		frequency	-  filter tuning frequency
%		color		-  color of the response
%		number_sigmas	-  Gabor parameter
%		number_periods	-  Gabor parameter
%
%	SEE ALSO
%		gabor

if nargin < 1,
  freq = .1
  ['Using frequency of ' num2str(freq)]
end;

if nargin < 2,
  color = 'y';
end;

if nargin < 3,
  number_sigmas = 6;
end;

if nargin < 4,
  number_periods = 4;
end;

g = gabor (freq, number_sigmas, number_periods);

len = floor (length(g) + 1) / 2;
y = abs(fft(g));
plot ([0:.5 / (len-1):.5], y(1:len), color);
xlabel ('Frequency')
ylabel ('Amplitude')

title ('Gabor Filter Frequency Response')
if nargout < 1,
  y = 0;
end;

% This software provided by Mark Maimone (mwm@cmu.edu) as part of his Ph.D.
% thesis.  For more info, please see http://www.cs.cmu.edu/~mwm/thesis
%
% Release Date: 9 October 1997
%
% 	Carnegie Mellon University and the individuals associated with this
% project assume no liability for the fitness or performance of this software
% or any damages resulting from its use.  It's free, you get what you pay
% for...
