function y = gabor2(xfreq,yfreq,num_sig,num_periods)

% Gabor2(xfreq,yfreq,number_sigma,number_periods) -- Compute a 2D Gabor
%		filter with peak value == 1
%	xfreq -- Sinusoid frequency in X direction
%	yfreq -- Sinusoid frequency in Y direction
%	number_sigmas -- # Gaussian sigmas in the wavelet envelope [6]
%	number_periods -- # sinusoid periods to include (Nyquist
%			  theorem says at least 2) [4]

if nargin < 1,
	error ('Gabor2: must specify at least one frequency');
end;
if nargin < 2,
	yfreq = xfreq;
end;
if nargin < 3,
	num_sig = 6;
end;
if nargin < 4,
	num_periods = 4;
end;
if num_periods < 2,
	'Gabor2: WARNING!  Using fewer than the Nyquist-required # of periods'
end;

cenvelope = num_periods/xfreq;
c = [-cenvelope/2:cenvelope/2];
clen = length(c);
renvelope = num_periods/yfreq;
r = [-renvelope/2:renvelope/2];
rlen = length(r);

mat = zeros(rlen,clen);
for n = 1:rlen,
  mat(n,:) = c .* xfreq;
end;
for n = 1:clen,
  mat(:,n) = mat(:,n) + r' .* yfreq;
end;
y = gauss2(cenvelope/num_sig, renvelope/num_sig, num_sig) .* exp(i*2*pi*mat);
end;

% This software provided by Mark Maimone (mwm@cmu.edu) as part of his Ph.D.
% thesis.  For more info, please see http://www.cs.cmu.edu/~mwm/thesis
%
% Release Date: 9 October 1997
%
% 	Carnegie Mellon University and the individuals associated with this
% project assume no liability for the fitness or performance of this software
% or any damages resulting from its use.  It's free, you get what you pay
% for...
