function y = gabor(freq,num_sig,num_periods)

% Gabor(freq,number_sigma,number_periods) -- Compute a 1D Gabor filter with
%		peak value == 1
%	freq -- Sinusoid frequency
%	number_sigmas -- # Gaussian sigmas in the wavelet envelope [6]
%	number_periods -- # sinusoid periods to include (Nyquist
%			  theorem says at least 2) [4]

if nargin < 1,
	error ('Gabor: must specify frequency');
end;
if nargin < 2,
	num_sig = 6;
end;
if nargin < 3,
	num_periods = 4;
end;
if num_periods < 2,
	'Gabor: WARNING!  Using fewer than the Nyquist-required # of periods'
end;

envelope = num_periods/freq;
x = [-envelope/2:envelope/2];
y = ugauss(envelope/num_sig, num_sig) .* exp(i*2*pi*x*freq);
end;

% This software provided by Mark Maimone (mwm@cmu.edu) as part of his Ph.D.
% thesis.  For more info, please see http://www.cs.cmu.edu/~mwm/thesis
%
% Release Date: 9 October 1997
%
% 	Carnegie Mellon University and the individuals associated with this
% project assume no liability for the fitness or performance of this software
% or any damages resulting from its use.  It's free, you get what you pay
% for...
