function y = flplot(i1, i2, i3, i4, i5, i6, i7, i8, i9, iA, iB, iC)
%
%	FLPLOT -- FLexible PLOT command that doesn't require input triples.
%		  Instead, the parameters to PLOT will be computed from the
%		  input, under the assumption that most X vectors will be
%		  omitted.  The only legal X specifications are those that
%		  have the same length as the following Y spec, and whose
%		  adjacent elements all differ by exactly 1.  X specs only
%		  affect the immediately following Y spec; embed the Y specs
%		  in a matrix if the X spec should apply to all of them.
%
%		  The expected order is the same as PLOT, but you're allowed
%		  to omit both the X and color specs:
%
%			flplot ( {X-vector,} Y-vector {, color} ... )
%
%		  Matrices will be be split into columns, unless the X
%		  spec only matches a row-based split.
%
%	Examples:
%
%		flplot([1:20])				Plot one vector
%		flplot([1:2:100],log([1:2:100]))	Plot two vectors
%		flplot([11:60],log([1:2:100]))		Plot one vector
%		flplot([10:19],[1:10],[1:1.1:15],[1:1.2:20],'b',[1:1.3:25])
%							Plot four vectors
%		x=[1:40]; flplot(x+6, [x; x/2; x/1.5]')	Plot three vectors
%
%	Returns the number of functions plotted.  There is currently an
%	arbitrary limit of at most 12 input arguments.  See also FLPARSE, PLOT.

% Written by Mark Maimone (mwm@cs.cmu.edu) on 26 August 1995
% Updated 4 September 95 (mwm@cs.cmu.edu)  Now handles matrix input.

if nargin < 1,
  error ('Flplot:  no arguments given!');
end;

max_args = 12;  		%%% Number of potential input parameters

c = 'ymcrgbwk';			%%% Default color cycle

if nargin < 12,
  iC = '';
end;
if nargin < 11,
  iB = '';
end;
if nargin < 10,
  iA = '';
end;
if nargin < 9,
  i9 = '';
end;
if nargin < 8,
  i8 = '';
end;
if nargin < 7,
  i7 = '';
end;
if nargin < 6,
  i6 = '';
end;
if nargin < 5,
  i5 = '';
end;
if nargin < 4,
  i4 = '';
end;
if nargin < 3,
  i3 = '';
end;
if nargin < 2,
  i2 = '';
end;

nextplot = get(gca,'NextPlot');		%%% Store the current plot status
this = 1;				%%% Current argument
count = 1;				%%% Current plot
mc = 0;					%%% matrix column index

while this <= max_args & this <= nargin,
  if (this == 1),
     [step,x,y,color,mc] = flparse(c(rem(count-1,length(c))+1),mc,i1,i2,i3);
  elseif (this == 2),
     [step,x,y,color,mc] = flparse(c(rem(count-1,length(c))+1),mc,i2,i3,i4);
  elseif (this == 3),
     [step,x,y,color,mc] = flparse(c(rem(count-1,length(c))+1),mc,i3,i4,i5);
  elseif (this == 4),
     [step,x,y,color,mc] = flparse(c(rem(count-1,length(c))+1),mc,i4,i5,i6);
  elseif (this == 5),
     [step,x,y,color,mc] = flparse(c(rem(count-1,length(c))+1),mc,i5,i6,i7);
  elseif (this == 6),
     [step,x,y,color,mc] = flparse(c(rem(count-1,length(c))+1),mc,i6,i7,i8);
  elseif (this == 7),
     [step,x,y,color,mc] = flparse(c(rem(count-1,length(c))+1),mc,i7,i8,i9);
  elseif (this == 8),
     [step,x,y,color,mc] = flparse(c(rem(count-1,length(c))+1),mc,i8,i9,iA);
  elseif (this == 9),
     [step,x,y,color,mc] = flparse(c(rem(count-1,length(c))+1),mc,i9,iA,iB);
  elseif (this == 10),
     [step,x,y,color,mc] = flparse(c(rem(count-1,length(c))+1),mc,iA,iB,iC);
  elseif (this == 11),
     [step,x,y,color,mc] = flparse(c(rem(count-1,length(c))+1),mc,iB,iC,'');
  elseif (this == 12),
     [step,x,y,color,mc] = flparse(c(rem(count-1,length(c))+1),mc,iC,'','');
  end;

  plot(x,y,color);
  this = this + step;
  count = count + 1;
  set(gca,'NextPlot','add');
end;

set(gca,'NextPlot',nextplot);
y=count-1;
end;

% This software provided by Mark Maimone (mwm@cmu.edu) as part of his Ph.D.
% thesis.  For more info, please see http://www.cs.cmu.edu/~mwm/thesis
%
% Release Date: 9 October 1997
%
% 	Carnegie Mellon University and the individuals associated with this
% project assume no liability for the fitness or performance of this software
% or any damages resulting from its use.  It's free, you get what you pay
% for...
