function y = dx(x)
%
% Compute the local derivative of a matrix
%

if nargin < 1,
	error ('Need a vector or matrix input');
end;

[a b] = size(x);
if (b == 1),
    if (a == 1),
	error ('Cannot compute derivative of a single value');
    end;
    'dx:  WARNING!  Inverting vector input'
    x = x';
    b = a;
end;

y = x(:,2:b) - x(:,1:b-1);

% This software provided by Mark Maimone (mwm@cmu.edu) as part of his Ph.D.
% thesis.  For more info, please see http://www.cs.cmu.edu/~mwm/thesis
%
% Release Date: 9 October 1997
%
% 	Carnegie Mellon University and the individuals associated with this
% project assume no liability for the fitness or performance of this software
% or any damages resulting from its use.  It's free, you get what you pay
% for...
