function y = dsmin (mat)

% Dsmin -- Find the minimum indicies from all columns of a Disparity Space
% matrix.  We need this because the builtin "min" won't extract indices from
% matrix input.
%
%	mat --  Disparity Space matrix; rows are disparities, columns are
%		pixel indices.

[v h] = size(mat);

y = zeros(1,h);
for i= 1:h,
  big = max(mat(:,i));
  vec = (mat(:,i) > 0) .* mat(:,i) + (mat(:,i) <= 0) .* big;
  [val y(i)] = min (vec);

end;

% This software provided by Mark Maimone (mwm@cmu.edu) as part of his Ph.D.
% thesis.  For more info, please see http://www.cs.cmu.edu/~mwm/thesis
%
% Release Date: 9 October 1997
%
% 	Carnegie Mellon University and the individuals associated with this
% project assume no liability for the fitness or performance of this software
% or any damages resulting from its use.  It's free, you get what you pay
% for...
