function fun = dipd(disp,filt)
%	dipd(disparity,filters)	-- Display Ideal Phase Differences for
%		the given disparity.  If no filters are given, linear
%		wavelength samples from 2:128 will be used.  The label
%		for the axis will be chosen based on the content of
%		filters; if all are greater than 2, 'Wavelength' is
%		used.  If all are between 0 and .5, 'Frequency' is used.
%

if (nargin < 1),
	error ('dipd:  Must give a disparity');
end;

if (nargin < 2),
	filt = [2:128];
end;

if (min(filt) >= 2 & max(filt) >= 2),
	type = 1;		%%%  Wavelengths were given
else
	if ((min(filt) > 0) & (max(filt) <= .50001)),
		type = 2;		%%%  Frequencies were given
	else
		error ('dipd:  Filters aren''t frequencies or wavelengths!!');
	end;
end;

if type == 1,
	ipd = 2*pi*disp ./ filt;
else
	ipd = 2*pi*disp .* filt;
end;

ipdplot(filt, ipd)
ylabel('Phase Diff');
title(['Disparity ' num2str(disp)]);
if type == 1,
	xlabel ('Wavelength');
else
	xlabel ('Frequency');
end;
end;

% This software provided by Mark Maimone (mwm@cmu.edu) as part of his Ph.D.
% thesis.  For more info, please see http://www.cs.cmu.edu/~mwm/thesis
%
% Release Date: 9 October 1997
%
% 	Carnegie Mellon University and the individuals associated with this
% project assume no liability for the fitness or performance of this software
% or any damages resulting from its use.  It's free, you get what you pay
% for...
