function y = char2indices (charvec)
%	CHAR2INDICES (charvec) -- Given a characteristic vector, build a
%				   list of indices.

if nargin < 1,
  error ('char2indices:  must give a characteristic vector!')
end;


[a b] = size(charvec);
if (a == 1),
  charvec = charvec';
  [a b] = size(charvec);
end;

charvec = (charvec ~= 0);
s = sum (charvec);

result = zeros(s,b);

for c = 1:b,
  index = 1;
  for d = 1:a,
    if charvec(d,c),
      result(index,c) = d;
      index = index + 1;
    end;
  end;
end;

y = result;
end;

% This software provided by Mark Maimone (mwm@cmu.edu) as part of his Ph.D.
% thesis.  For more info, please see http://www.cs.cmu.edu/~mwm/thesis
%
% Release Date: 9 October 1997
%
% 	Carnegie Mellon University and the individuals associated with this
% project assume no liability for the fitness or performance of this software
% or any damages resulting from its use.  It's free, you get what you pay
% for...
