function y = autoshift(i)
%	autoshift (image) -- Compute the translation required to extract
%			     structure from an autostereogram

[a b] = size(i);

f = fft2(i-sum(sum(i))/(a*b));	%%%  Compute the spectrum without the DC
sig = fftshift(sum(abs(f)));	%%%  Sum up the columns; assumes vertical
				%%%  structure implicit in autostereograms
p = findpeaks(sig,.1,3);	%%%  Locate filters with greatest response;
				%%%	Result should be DC with two
				%%%	surrounding peaks
freqindex = max(p) - (b/2+1);	%%%  Compute the index of the second peak freq
y=b/freqindex;			%%%  Convert to wavelength; we've got it!
end;

% This software provided by Mark Maimone (mwm@cmu.edu) as part of his Ph.D.
% thesis.  For more info, please see http://www.cs.cmu.edu/~mwm/thesis
%
% Release Date: 9 October 1997
%
% 	Carnegie Mellon University and the individuals associated with this
% project assume no liability for the fitness or performance of this software
% or any damages resulting from its use.  It's free, you get what you pay
% for...
