function y = absdiffmod(l,r)

% ABSDIFFMOD(l,r)  --  Compute the smallest difference between two phases;
%			maps its arguments to [0,2pi] before comparing
%			Results will always be in [0,pi] (thanks to the abs).

diff = mod2pi(l)-mod2pi(r);
up = abs(diff + 2 * pi);
down = abs(diff - 2 * pi);
diff = abs(diff);

use_up = (up < diff);
use_down = ~use_up & (down < diff);
use_same = ~use_up & ~use_down;

y = use_up .* up + use_down .* down + use_same .* diff;
end;

% This software provided by Mark Maimone (mwm@cmu.edu) as part of his Ph.D.
% thesis.  For more info, please see http://www.cs.cmu.edu/~mwm/thesis
%
% Release Date: 9 October 1997
%
% 	Carnegie Mellon University and the individuals associated with this
% project assume no liability for the fitness or performance of this software
% or any damages resulting from its use.  It's free, you get what you pay
% for...
