/* stream.h -- generic stream data type */
/* Copyright 1989 Carnegie Mellon University */

/* NOTE: this package was inherited from a Mac implementation of Adagio in
 * which the user interface was a text editor on an Adagio score.  A stream
 * interface allowed Adagio to parse data right out of the in-memory editor
 * buffer.  The work fell by the wayside and is no longer supported.
 */

/****************************************************************************
*    Change Log
* July 1, 1987     | F.H: Created Change Log
* July 1, 1987    | F.H: Changed all prefixes of "stream" to "str". Lattice C
*       |    doesn't like long names.
****************************************************************************/

/* generic stream header
 * (the representation of every stream starts with this header) */
typedef struct generic_stream_struct {
    void        (*close)();
    int (*getchr)();
    boolean     (*getline)();
    ulong       (*getpos)();
    void        (*putchr)();
    void        (*putstring)();
    void        (*setpos)();
} 
StreamProcs, *StreamPtr;

/*
 * StreamPtr    your_Create(...your args...)
 *
 * your_Create is supplied by a particular stream implementation.  for example,
 * a memory read stream is created by calling memstream_CreateRead(...).
 * once created, a stream responds to a subset of the following generic
 * stream operations.  (naturally, input streams don't need to respond to
 * output operations and vice versa):
 *
 * void str_Close(StreamPtr stream);
 * int  str_GetChar(StreamPtr stream);
 * boolean    str_GetLine(StreamPtr stream, char *line, ushort lineSize);
 * ulong    str_GetPos(StreamPtr stream);
 * void str_PutChar(StreamPtr stream, char);
 * void str_PutString(StreamPtr stream, char *s);
 * void str_SetPos(StreamPtr stream, ulong newPos);
 */

#ifdef MACINTOSH
#define str_Close(s)    ((void) (*(s)->close)(s))
#define str_GetChar(s)  ((int) (*(s)->getchr)(s))
#define str_GetLine(s,l,z)    ((boolean) (*(s)->getline)((s),(l),(z)))
#define str_GetPos(s)   ((ulong) (*(s)->getpos)(s))
#define str_PutChar(s,c)    ((void) (*(s)->putchr)((s),(char)(c)))
#define str_PutString(s,str)    ((void) (*(s)->putstring)((s),(str)))
#define str_SetPos(s,p) ((void) (*(s)->setpos)((s),(p)))
#endif

#ifdef LATTICE
#define str_Close(s)    ((*(s)->close)(s))
#define str_GetChar(s)  ((int) (*(s)->getchr)(s))
#define str_GetLine(s,l,z)    ((boolean) (*(s)->getline)((s),(l),(z)))
#define str_GetPos(s)   ((ulong) (*(s)->getpos)(s))
#define str_PutChar(s,c)    ((*(s)->putchr)((s),(char)(c)))
#define str_PutString(s,str)    ((*(s)->putstring)((s),(str)))
#define str_SetPos(s,p) ((*(s)->setpos)((s),(p)))
#endif
