/* seqextns.c -- this is an example adagio extension */
/*
 * to make a trill, say
 *    !call trill(pitch,total_duration,interval,note_duration,loud)
 */

#include "stdio.h"
#include "cext.h"
#include "userio.h"
#include "midifns.h"
#include "timebase.h"
#include "moxc.h"
#include "seq.h"
#ifdef AMIGA
#ifdef LATTICE
#include "amiga.h"
#endif
#include "exec/exec.h"
#endif
#include "cmtcmd.h"

void triller(seq, voice, pitch, note_dur, interval, loud, n)
  seq_type seq;
  int voice;
  long pitch, note_dur, interval, loud, n;
{
    /* the note we play is determined by even(n) */
    int current_pitch = pitch;
    /* gprintf(TRANS,
	    "triller: n %ld, pitch %ld, interval %ld, note_dur %ld, loud %ld\n",
	    n, pitch, interval, note_dur, loud); */
    if (n & 1) current_pitch += interval;
    if (!seq->runflag) return;  /* don't schedule any more */
    /* turn on current note: */
    seq_noteon(seq, voice, current_pitch, (int) loud); 
    seq_cause_noteoff(seq, (delay_type) note_dur, voice, current_pitch);
    if (n > 1) {
	/* schedule next note in trill */
	cause((delay_type) note_dur, triller, seq, voice, pitch, note_dur, interval,
				 loud, n - 1);
    } else seq_end_event(seq);
}


void trill(pitch, dur, interval, note_dur, loud)
  /* note that all parameters must be longs */
  long pitch, dur, interval, note_dur, loud;
{
    /* first figure out how many trill notes to actually make:
     *  we want an even number of notes
     */
    /* avoid divide by zero */
    long n = dur / max(note_dur, 1);
/*    gprintf(TRANS, 
	"trill: pitch %ld, dur %ld, interval %ld, note_dur %ld, loud %ld\n",
	pitch, dur, interval, note_dur, loud); */
    if (n & 1) n++;
    if (n == 0) return;
    note_dur = dur / n;

    /* sequence is a global pointing to the current sequence
     * The seq player assumes the following:
     *  if !runflag, then we're advancing time just to turn off notes
     *  if !note_enable then we're advancing to get to some time location
     *          so don't turn on any notes, but be ready to roll forward
     */
    if (!sequence->runflag) return;
    if (loud <= 0) loud = 100;
    sequence->noteoff_count++;
    triller(sequence, vc_voice(sequence->current->nvoice),
	    pitch, note_dur, interval, loud, n);
}


int samplevar;
#define sampleveclen 10
int samplevec[sampleveclen];

void showdef()
{
    int i;
    gprintf(TRANS, "samplevar = %d\nsamplevec =", samplevar);
    for (i = 0; i < sampleveclen; i++) {
	gprintf(TRANS, " %d", samplevec[i]);
    }
    gprintf(TRANS, "\n");
}


void seq_extensions()
{
    defun("TRILL", (defun_type) trill);
    defvar("SAMPLEVAR", &samplevar);
    defvec("SAMPLEVEC", samplevec, 10);
    defun("SHOWDEF", (defun_type) showdef);
}

