/******************************************************************************
*
*   Source Control
*   --------------
* Copyright (c) 1988 Commodore-Amiga, Inc.
* 
* Executables based on this information may be used in software
* for Commodore Amiga computers.  All other rights reserved.
* 
* This code based on Commodore's propjoy.c program, which carries
* the Copyright info listed above.
*
******************************************************************************/

#include "switches.h"

#include <exec/types.h>
#include <exec/nodes.h>
#include <exec/execname.h>

#include <graphics/gfxbase.h>
#include <graphics/graphint.h>

#include <hardware/cia.h>
#include <hardware/custom.h>
/* RBD added this 29Jul92: Commodore must have taken custom out of 
 * custom.h because the hardware address is no longer the same in
 * all models; however, I don't know how to find the address.  Since
 * MY hardware hasn't changed, I know the following will work for me...
 */
#include "custaddr.h"
#include <hardware/intbits.h>

#include <resources/potgo.h>

#include "midi/camd.h"
/* #include "camdfns.h" */
#include "prop1.h"
#include "cleanup.h"

#define REV (0L)

/* use system defined addresses for potgo and pot1dat */

#define POTGO       &custom.potgo
#define POT0DAT     &custom.pot0dat
#define POT1DAT     &custom.pot1dat
#define JOY0DAT     custom.joy0dat
#define JOY1DAT     custom.joy1dat

/* vertical blank interrupt server priority   */

#define HIGHINTPRI 127L     /* needs to be replaced with priority relative */
#define LOWINTPRI -127L     /* needs to be replaced with priority relative */

#define NUM_SERVERS 2

/* bit number defines for potgo ... */

#define START_B     0   

#define DATRX_B     8   
#define DATRY_B     10

#define DATLX_B     12  
#define DATLY_B     14

/* masks ... */

#define START_F     (1L << START_B)
#define DATRX_F     (1L << DATRX_B)
#define DATRY_F     (1L << DATRY_B) 
#define DATLX_F     (1L << DATLX_B)
#define DATLY_F     (1L << DATLY_B) 

#define RPOTX       (START_F | DATRX_F) 
#define RPOTY       (START_F | DATRY_F) 
#define RPOTXY      (START_F | DATRX_F | DATRY_F) 

#define LPOTX       (START_F | DATLX_F) 
#define LPOTY       (START_F | DATLY_F) 
#define LPOTXY      (START_F | DATLX_F | DATLY_F) 

extern struct MidiNode *cmt_mi;

extern struct GfxBase *GfxBase = NULL;
struct PotgoBase *PotgoBase = NULL;

/* global storage for potdat */

UWORD oldbits = NULL;
UWORD potbits = NULL;

int prop_1_hysteresis = 0;
int prop_1_left_data = 0;
int prop_1_right_data = 0;
int prop_1_left_button = 0;
int prop_1_right_button = 0;
short prop_1_left_integral = 0;
short prop_1_right_integral = 0;
int prop_1_left_enable = 0;
int prop_1_right_enable = 0;
int prop_1_events = 0;
int prop_running = 0;

/* create server-task to read the proportional joysticks,*/ 
/* update potdat, and then poke potgo to start next data read */

struct Interrupt PropIntNode[NUM_SERVERS] = {NULL};


int

#ifdef LATTICE
__saveds
__interrupt
#endif

first_server()
{
    register short data;
    register short delta;
    register ULONG potdat;
#ifdef AZTEC
#asm
	movem.l d2/d3/a4,-(sp)
	jsr _geta4#
#endasm
#endif
    /* read previous proportional joystick values */
    potdat = *(ULONG *)POT0DAT;

    /* poke potgo, restore old bits */
    WritePotgo(oldbits,((~1)<<8)|oldbits);

/*    if (prop_1_left_enable) { */
	data = (potdat >> 8) & 0xFF;
	delta = data - prop_1_left_data;
	if (delta < 0) delta = -delta;
	if (delta == 0) {
	    prop_1_left_integral = 0;
	} else {
	    prop_1_left_integral += delta;
	    if (prop_1_left_integral > prop_1_hysteresis) {
		prop_1_left_data = data;
		prop_1_events |= PROP_1_LEFT_CHANGE;
		Signal(FindTask(0L), 1L << cmt_mi->RecvSigBit);
		prop_1_left_integral = 0;
	    }
	    }
/*    } */

#ifdef OMIT
/*    if (prop_1_right_enable) { */
	data = potdat & 0xFF;
	delta = data - prop_1_right_data;
	if (delta < 0) delta = -delta;
	 if (delta == 0) {
	    prop_1_right_integral = 0;
	} else {
	    prop_1_right_integral += delta;
	    if (prop_1_right_integral > prop_1_hysteresis) {
		prop_1_right_data = data;
		prop_1_events |= PROP_1_RIGHT_CHANGE;
		Signal(FindTask(0L), 1L << cmt_mi->RecvSigBit);
		prop_1_right_integral = 0;
	    }
	    }
/*    } */
#endif
    ;
    ; /* sets jump point for conditional */
    ;
    /* be nice -- let other servers run, too */
#ifdef AZTEC
#asm
	movem.l (sp)+,d2/d3/a4
	moveq.l #0,d0
#endasm
#else
	return 0;
#endif
}

int

#ifdef LATTICE
__saveds
__interrupt
#endif

second_server()
{
#ifdef AZTEC
#asm
	movem.l d2/d3/a4,-(sp)
	jsr _geta4#
#endasm
#endif
    /* poke potgo, start prop joystick read  */
    WritePotgo(potbits,((~1)<<8)|potbits);

    /* be nice -- let other servers run, too */
#ifdef AZTEC
#asm
	movem.l (sp)+,d2/d3/a4
	moveq.l #0,d0
#endasm
#else
	return 0;
#endif
}


int

#ifdef LATTICE
__saveds
__interrupt
#endif

third_server()
{
#ifdef AZTEC
#asm
	moveq.l #0,d0
#endasm
#else
	return 0;
#endif
}

void prop_poll()
{
    register short data;
    data = (JOY1DAT >> 9) & 1;
    if (data != prop_1_left_button) {
	prop_1_left_button = data;
	prop_1_events |= BUTTON_1_LEFT_CHANGE;
    }

    data = (JOY1DAT >> 1) & 1;
    if (data != prop_1_right_button) {
	prop_1_right_button = data;
	prop_1_events |= BUTTON_1_RIGHT_CHANGE;
    }
}


int prop_init()
{
    if (prop_running) return TRUE;
    prop_running = 1;

    /* set server priorities */ 
    PropIntNode[0].is_Node.ln_Pri = HIGHINTPRI;  
    PropIntNode[0].is_Node.ln_Type = NT_INTERRUPT;
    PropIntNode[0].is_Node.ln_Name = "Prop High Pri";
    PropIntNode[0].is_Code = first_server;

    PropIntNode[1].is_Node.ln_Pri = LOWINTPRI;   
    PropIntNode[1].is_Node.ln_Type = NT_INTERRUPT;
    PropIntNode[1].is_Node.ln_Name = "Prop Low Pri";
    PropIntNode[1].is_Code = second_server;

    if ((GfxBase = (struct GfxBase *)
	  OpenLibrary("graphics.library", REV)) != NULL) {
	if ((PotgoBase = (struct PotgoBase *) 
	      OpenResource(POTGONAME, REV)) != NULL) {
	    /* remember currently used bits */
	    oldbits = ~(AllocPotBits(~1));

	    /* restore previous state of bit allocation */
	    FreePotBits(~oldbits);

	    /* now attempt to allocate start potbit */
	    potbits = AllocPotBits(START_F);

	    /* add interrupt servers */

	    Forbid();
	    AddIntServer(INTB_VERTB, &PropIntNode[0]);
	    AddIntServer(INTB_VERTB, &PropIntNode[1]);
	    Permit();
	    cu_register(prop_term, NULL);
	    return TRUE;
	}
    } 
    return FALSE;
}


void prop_term()
{
    if (!prop_running) return;
    prop_running = 0;
    
    Forbid();
    RemIntServer(INTB_VERTB, &PropIntNode[0]);
    RemIntServer(INTB_VERTB, &PropIntNode[1]);
    Permit();

    /* free potbits */
    FreePotBits(potbits);

    CloseLibrary(GfxBase);
}
