/* mpuSB.h for use with mpuSB.c */

/* Copyright 1996 Intelligistics, Inc. */

/*****************************************************************************
* Change Log
*   Date    | who : Change
*-----------+-----------------------------------------------------------------
* 03-Jun-96 | GWL : Created.  Note that tabs are q4 spaces.
*****************************************************************************/

/*
    Please see mpu.h for the process-controlling constants.
*/

#define MPU_SB_BASE          0x0220   /* Address of MPU-401 by default */
#define MPU_SB_IRQ           5        /* Default IRQ */
#define DINR_SB              0x80     /* Data Input Ready, yes==1 */
#define DOUTR_SB             0x80     /* Data Output Ready, yes==0 */
#define MPU_SB_RESET_AKK     0xaa     /* DSP reset is successful */
#define MPU_SB_INPUT_MIDI    0x31     /* Normal mode, allow input interrupts */
#define MPU_SB_OUTPUT_MIDI   0x38     /* Normal mode, send output */
#define MPU_SB_UART_IRUPT    0x35     /* UART Interrupt mode */

void mPutByte(byte dat);
int SB_DSP_reset(void);


