/* camdmidi.h -- amiga midi interface header file */

#define clearmsg(x) (x).mm_Msg=0
#define setstatus(x,a) (x).mm_Status=(a)
#define setdata1(x,a) (x).mm_Data1=(a)
#define setdata2(x,a) (x).mm_Data2=(a)

extern ULONG timeoffset;
extern ULONG event_mask;
extern MidiMsg cmt_msg;
extern ULONG *camdtime;

extern struct CamdBase *CamdBase;
extern struct MidiNode *cmt_mi;

extern UBYTE amigaerrflags;

#define AMIGA_ERROR_CHECK { \
	amigaerrflags = GetMidiErr(cmt_mi); \
	if (amigaerrflags) set_error_flags(amigaerrflags); }

void amiga_midi_init(void);
void close_camd(void);
void delete_midi(void *obj);
void remove_sysex_buffer(void *obj);
void set_error_flags(UBYTE amigaerrflags);
