/* seqplay -- a little demo that plays a sequence */

#include "cmtprog.h"
#include "seq.h"
#include "seqread.h"

#ifdef THINK_C
#include "console.h"
#endif

boolean play_score();
void cmt_init();

/* has moxc been initialized yet? */
static boolean initialized = false;

/* The CMU MIDI Toolkit is normally passed a unix-style array of
   command-line arguments.  This example does not pass arguments to 
   the CMU MIDI Toolkit to keep it as simple as possible
 */
 

main(argc, argv)
  int argc;
  char *argv[];
{
#ifdef THINK_C
	/* Macintosh needs help to provide Unix-style command line */
	argc = ccommand(&argv);
#endif
    play_score("demo.gio");     /* for the demo, load a known file */
    while (play_score(NULL)) ;  /* NULL means prompt user for a file */
    EXIT(0);
}


boolean play_score(filename)
  char *filename;
{
    FILE *file = NULL;

    if (!initialized) {
	cmt_init();
	initialized = true;
    }
    file = fileopen(filename, "gio", "r", "Adagio score file");
    /* see adagio.c for example of how to read in standard midi files */
    if (file) {
	seq_type seq = seq_create();
	seq_read(seq, file);
	fclose(file);
	while (askbool("Play Score", true)) {
	    seq_reset(seq);
	    seq_play(seq);
	    moxcrun();
	}
	seq_free(seq);
	return true;
    } else return false;
}


void cmt_init()
{
    /* make a fake argv for moxcinit() */
    char *argv[1];
    argv[0] = "xlisp";
    if (!initialized) {
	if (moxcinit(1, argv)) {
	    initialized = true;
	    seq_extensions();
	}
    }
}


