/* moxctest.c -- a test program illustrating moxc */
/*
 * this program plays a short figure on every keydown
 */

#include "musiprog.h"

char *app_syntax = "";

/* loud(n) can be used to set the loudness level sent by note() */
/**/
#define loud(l) moxc_loudness = (l);
int moxc_loudness = 100;


/* pnote -- a simple way to make a midi note on channel 1 */
/**/
void pnote(pitch, dur)
{
    midi_note(1, pitch, moxc_loudness);
    cause((long) dur, midi_note, 1, pitch, 0);
}


void mainscore()
{
    int r;

    /*
     * turning on continuous controller messages (e.g. aftertouch messages)
     * will load the cpu, so only use this if you need it!
     */
     midi_cont(true);

    /*
     * play a note with a random pitch:
     */
    pnote(r = random(0, 100), 20);

    /*
     * cause mainscore to run every 2 seconds
     */
    cause(200, mainscore);

    gprintf(TRANS, "random(0, 100) = %d\n", r);
}


void keyup(int c, int k) /* this gets called whenever a key goes up */
{               /* turn off all the notes turned on by keydown */
    cause(40, midi_note, c, k+1, 0);
    cause(70, midi_note, c, k-1, 0);
    cause(95, midi_note, c, k+2, 0);
    cause(115, midi_note, c, k-2, 0);
    cause(130, midi_note, c, k+3, 0);
    cause(140, midi_note, c, k-3, 0);
    cause(145, midi_note, c, k+4, 0);
}

void keydown(int c, int k, int v) /* this is called when a keyboard note is pressed */
{                       /* schedule a short phrase transposed by k */
    cause(40, midi_note, c, k+1, v);
    cause(70, midi_note, c, k-1, v);
    cause(95, midi_note, c, k+2, v);
    cause(115, midi_note, c, k-2, v);
    cause(130, midi_note, c, k+3, v);
    cause(140, midi_note, c, k-3, v);
    cause(145, midi_note, c, k+4, v);
}

void ctrlchange(int chan, int ctrl, int value)
{
    gprintf(TRANS, "ctrlchange: chan %d, ctrl %d, value %d\n",
		   chan, ctrl, value);
}


void prgmchange(int chan, int value)
{
    gprintf(TRANS, "prgmchange: chan %d, value %d\n", chan, value);
}


void bendchange(int chan, int value)
{
    gprintf(TRANS, "bendchange: chan %d, value %d\n", chan, value);
}

void peddown(int c)
{
    gprintf(TRANS, "peddown, chan %d\n", c);
}

void pedup(int c)
{
    gprintf(TRANS, "pedup, chan %d\n", c);
}

void asciievent(char c)
{
    if (c == 'q') quit();
    else if (c == 'n') midi_thru(true);
    else if (c == 'f') midi_thru(false);
    else gprintf(TRANS, "Type q to quit.\n");
}

/* touchchange -- after touch handler */
/**/
void touchchange(int chan, int value)
{
    gprintf(TRANS, "touchchange, chan %d, value %d\n", chan, value);
}


/* coda -- what to do at end of performance */
/*
 * NOTE: this is called just before closing down the midi interface.
 */
void coda(void)
{
}


/* midievent -- called when mididecode == false */
/**/
void midievent(data)
  unsigned char data[4];
{
}


/* sysex -- sysex message handler */
/**/
void sysex()
{
	/* Insert sysex actions here.
	   Hint: get the sysex message by calling getxbuf
	 */
}


#ifdef AMIGA
void buttonchange(number, value)
{
}

void propchange(number, value)
{
	/* insert propchange actions here */
}
#endif
