/* mapper.h */

#define mapevt_prog 1
#define mapevt_dly 2
#define mapevt_nt 3
#define mapevt_call 4
#define mapevt_ret 5
#define mapevt_go 6
#define mapevt_ctrl 7
#define mapevt_pass 8
#define mapevt_noop 9
#define mapevt_redo 10
#define mapevt_score 11
#define mapevt_print 12

#define mapevt_transpose_flag 128
#define mapevt_sign 64
#define mapevt_number (63)
#define duration_transpose_flag 0x80000000
#define duration_product_flag 0x40000000
#define duration_duration_field 0x3FFFFFFF
#define duration_sign 0x20000000
#define duration_sign_extend 0xC0000000
#define mapevt_gate_flag 0x8000
#define mapevt_cycle_flag 0x4000
#define mapevt_rate_mask 0x3FFF

typedef struct mapevt_struct {
    struct mapevt_struct *next;
    unsigned char cmd;  /* see defines above */
    unsigned char chan; /* midi channel, 1-16 */
    unsigned char value;/* midi program, key number, transp, call or go target:
			 *  Note: high order bit is "transpose" bit
			 *        Bit 6 is the sign bit.
			 */
    unsigned char vel;  /* midi velocity, same bits as value field.
			 * data is shifted right one bit (no low-order bit)
			 */
    short gate_and_rate;/* rate for scores; sign bit -> GATED */
    union {
	long dur;       /* duration, high order bit means alteration
			   bit 30 indicates "+" (0) or "*" (1)
			   if "*", then number is stored as percentage
			 */
	int score_id;   /* index to sequence table */
	char *msg;      /* message to print */
    } u;
} mapevt_node, *mapevt_type;

#define map_len 38
#define map_init 36
#define map_any 37

typedef struct {
    int chan;  /* or zero for global */
    mapevt_type keymap[map_len];
} map_node, *map_type;

extern map_type maps[];
extern char *active_maps[];

map_type map_create();
#define map_free(map) memfree((char *) (map), sizeof(map_node))
char map_read();
void map_event();
void map_insert_call();
void map_insert_ctrl();
void map_insert_dly();
void map_insert_go();
void map_insert_nt();
void map_insert_prog();
void map_insert_ret();
void map_insert_noop();
void map_insert_pass();
void map_insert_print();
void map_insert_redo();
void map_insert_seq();
void map_install();
void map_noteoff();
#define mapevt_alloc() ((mapevt_type) memget(sizeof(mapevt_node)))
#define mapevt_free(e) memfree((char *) (e), sizeof(mapevt_node))
void mapevt_free_a_list();
void mapper_flush_scores();
void mapper_show_active();
#define noteoff_alloc() ((noteoff_type) memget(sizeof(noteoff_node)))
#define noteoff_free(n) memfree((char *) (n), sizeof(noteoff_node))
