#include "switches.h"
#include "cext.h"
#include "stdio.h"
#include "userio.h"
#include "cmdline.h"
#include "scan.h"
#include "midifns.h"
#include "timebase.h"
#include "seq.h"
#include "mapper.h"
#include "moxc.h"

char *app_syntax = "scan<s>turn on scanner debugging";

FILE *f;

void stay_alive()
{
    /* gprintf(TRANS, "v %ld t %ld; ", virttime, gettime()); */
    cause(100, stay_alive); 
}


char lastfile_name[100];

void mainscore()
{
    char first;
    char *file_name = cl_arg(1);
    char *extras = cl_arg(2);
    if (extras) gprintf(ERROR, "Extra (filename?) argument ignored: %s\n",
			extras);
    mapper_init();
    if (!file_name) file_name = "demo.crn";
    f = fileopen(file_name, "crn", "r", "Map file");
    if (f) {
	strcpy(lastfile_name, fileopen_name);
	first = map_read(f);
	fclose(f);
	if (first) {
	    /* print reminder; this must print before calling map_install, because
	       the init segment may have a "go" to another map
	     */
	    gprintf(TRANS, "Installing Map %c ...\n", first);
	    map_install(first);
	} else {
	    gprintf(TRANS, "no map!\n");
	}
    }
    stay_alive();
}

void propchange(number, value)
{
}


/* buttonchange -- handler */
/**/
void buttonchange(number, value)
{
}

/* ctrlchange -- control change handler */
/**/
void ctrlchange(int chan, int ctrl, int value)
{
    /* insert control change actions here */
}
