/* keydef -- definitions for output cascades from keyboard input */

/*
    Copyright pending, Intelligistics, Inc.

    Please see the notice in the main module associated with 
    this submodule: c200.c

*/
/*
    Revisions:

    200 -- gwl I*I 19-JUn-90 -- created
*/


/* determining parameters */

#define		NALGS		3			/* processing algorithms */
#define		NCASCS		20			/* max number of output cascades */	
#define		NCHANS		16			/* max number of channels */
#define		NECHOVALS	100			/* max number of echo descriptors */
#define		NHOTKEYS	100			/* algorithm 2: max number of hot keys */
#define		NINSTS		3			/* max number of input instruments */
#define		NKEYSIN		300			/* algorithm 1: max number of keys */
#define		NMODES		100			/* max number of output modes */
#define		NOKEYSDOWN	-1			/* algo 1: none of 0 to 255 obtained */
#define		NOMODES		10			/* max modes per inst */	
#define		NUSEMAX		8			/* algo 1: max keys used for a cascade */



/* instrument data */


struct	instdata
{
    int		channel;				/* input channel number */
    int		nomodes;				/* number of output modes */
    int		omode[NOMODES];			/* output modes */
    int		currprog;				/* current program */
    int		currchan;				/* for now, channel */
    struct	cascval *cp;			/* for now, cascade */
};


/* mode data */


struct	modedata					/* master mode list entry */
{
    int		algnum;					/* identify a list of procedures */
    union
    {
	struct	m000data	*m000p;
	struct	m001data	*m001p;
	struct	m002data	*m002p;
    } mp;
};


struct	modealgs					/* algorithm procedures list entry */
{
    void	(*init)();				/* initialization procedure */
    void	(*reset)();				/* reset procedure */
    void	(*keydown)();			/* keydown procedure */
    void	(*keyup)();				/* keyup procedure */
};


struct	m000data					/* algorithm 0: echo input */
{
    int		val[NECHOVALS];			/* output channels and transpositions */
};


struct	m001data					/* algorithm 1: listen for several keys */
{
    long	resetdelay;				/* delay before reset scan */
    long	timelast;				/* time of last up or down */
    long	time_down[NKEYSIN];		/* time when pressed */
    long	time_up[NKEYSIN];		/* time when released */
    int		key_in[NKEYSIN];		/* pitch pressed */
    int		vel_in[NKEYSIN];		/* velocity pressed */
    int		listening;				/* 1=save key, 0=skip */ 
    int		nkeysdown;				/* number of keys already pressed */
    int		nkeysup;				/* number of keys already released */
    int		nkeysnow;				/* current number of keys down */
    int		nkeysuse;				/* # keys needed to start cascade */
    int		usemore;				/* 1=continue playing, 0=wait for delay */
    struct	cascval  *cp;			/* cascade to play */		
};


struct	m002data					/* algorithm 2: listen for hot keys */
{
    int		nhot;					/* number of keys */
    int		hotkey[NHOTKEYS];		/* triggering keys */
    struct	cascval	*cp;			/* cascade to play */
};



/* externals */

extern struct instdata inst[NINSTS];	/* input instrument data */

extern struct modedata mode[NMODES];	/* output mode data */

extern struct modealgs algo[NALGS];		/* processing entry points */

extern struct cascval casc[NCASCS];		/* paramter files */



