/* cscdef.h -- definitions for cascades */

#define		LTEXT	100		/* length of title or file name for cascade */

/******************************************************************************
    note elements
******************************************************************************/

struct	noteval {
    int				pit;		/* pitch */
    int				dur;		/* duration */
    int				art;		/* articulation */
    int				lou;		/* loudness */
/*	struct	noteval	*prev;		/* chain back */
/*	struct	noteval	*next;		/* chain forward */
/*	struct	data	*spec;		/* special info */
};


/* to access note elements as an array */

struct	noteabs {
    int				i[4];		/* to access as an aray */
};


/* parameters for one note element */

#define		ELEM_NDOUBLE	2
#define		ELEM_NLONG		2
#define		ELEM_NINT		7

struct	elemval {
    double			chipbmin;	/* min change in increment per beat */
    double			chipbmax;
    long			chiptmin;	/* min change in increment per time */
    long			chiptmax;
    int				valmin;		/* min initial value */
    int				valmax;
    int				incmin;		/* min initial increment */
    int				incmax;
    int				endmin;		/* min limit */
    int				endmax;
    int				endflag;	/* flag to end event if limit exceeded */
};


/* to access parameters with arrays */

struct	elemabs {
    double			d[ELEM_NDOUBLE];
    long			l[ELEM_NLONG];
    int				i[ELEM_NINT];
};


/******************************************************************************
    cascade description
******************************************************************************/

#define		CASC_NELEM		4
#define		CASC_NLONG		2
#define		CASC_NINT		9

struct	cascval {
    struct	elemval	pit;		/* parameters for pitch */
    struct	elemval	dur;		/* parameters for duration */
    struct	elemval	art;		/* parameters for articulation */
    struct	elemval	lou;		/* parameters for loudness */
    long			scale;		/* scaling for chipt values */
    long			ranseed;	/* starting random seed */
    int				beat;		/* time of quarter note beat */
    int				chanbeg;	/* starting channel */
    int				chanend;	/* ending channel */
    int				nnotes;		/* max number of notes per event */
    int				nevents;	/* number of events per cluster */
    int				nclusters;	/* number of clusters per cascade */
    int				ncascades;	/* max number of cascades */
    int				sepabs;		/* min sep (hsecs) between clusters */
    int				sepran;		/* random addition to minimum separation */
    char			title[LTEXT];
/*	struct	data	*spec;		/* special instructions */
};


/* to access parm lists as arrays */

struct	cascabs {
    struct	elemval	p[CASC_NELEM];
    long			l[CASC_NLONG];
    int				i[CASC_NINT];
    char			t[LTEXT];
};


/******************************************************************************
    externals
******************************************************************************/

/* random number seed */

extern	long				randseed;

/* pointers to current areas */

extern	struct	cascval		*curcp;
extern	struct	elemval		*curep;
extern	struct	noteval		*curnp;

/* stop flags */

extern	int					stopclusters;		/* no further clusters */
extern	int					stopnotes;			/* no further notes */

/* option flags */

extern	int					prtendevents;		/* show end of event */
extern	int					prtranseeds;		/* show ranseed values */

